/* resource.c
   Resource fork operations
*/

#include "MacFS/mountrec.h"
#include "MacFS/LibFuncs/macreadwriteres.h"
#include "resource_struc.h"
#include "resource.h"

unsigned count_resources(MOUNT_RECORD *mr, CATALOG_RECORD *cr, LONGWORD type)
{
  unsigned long map_ofs, type_list_entry;
  LONGWORD bytes;
  unsigned n_types, i;
  unsigned char buf[10];

  if(mread_res(mr, cr, 4, sizeof(LONGWORD), buf, &bytes)
     || bytes != sizeof(LONGWORD))
    return 0;
  map_ofs = reorderlongword(buf);

  if(mread_res(mr, cr, map_ofs+24, 3*sizeof(WORD), buf, &bytes)
     || bytes != 3*sizeof(WORD))
    return 0;
  type_list_entry = map_ofs+reorderword(buf)+2;
  n_types = reorderword(buf+4)+1;

  for(i=0; i<n_types; i++, type_list_entry += sizeof(TYPELISTENTRY)) {
    if(mread_res(mr, cr, type_list_entry, 6, buf, &bytes) 
       || bytes != 6)
      return 0;
    if(*(LONGWORD *)buf==type)
      return reorderword(buf+4)+1;
  }
  return 0;
}

/* Return resource ID of the nth resource of a given type */
resid_t get_ind_resource(MOUNT_RECORD *mr, CATALOG_RECORD *cr, 
			 LONGWORD type, unsigned n)
{
  unsigned long map_ofs, type_list_ofs, cur_ofs;
  LONGWORD bytes;
  unsigned n_types, i, n_res=0;
  unsigned char buf[10];

  if(mread_res(mr, cr, 4, sizeof(LONGWORD), buf, &bytes)
     || bytes != sizeof(LONGWORD))
    return 0;
  map_ofs = reorderlongword(buf);

  if(mread_res(mr, cr, map_ofs+24, 3*sizeof(WORD), buf, &bytes)
     || bytes != sizeof(LONGWORD))
    return 0;
  type_list_ofs = map_ofs+reorderword(buf);
  n_types = reorderword(buf+4)+1;

  cur_ofs = type_list_ofs+2;
  for(i=0; i<n_types; i++, cur_ofs += sizeof(TYPELISTENTRY)) {
    if(mread_res(mr, cr, cur_ofs, 8, buf, &bytes)
       || bytes != 8)
      return 0;
    if(*(LONGWORD *)buf==type) {
      n_res = reorderword(buf+4)+1;
      cur_ofs = type_list_ofs+reorderword(buf+6);
      break;
    }
  }
  if(i==n_types) return 0;
  if(n>=n_res) return 0;

  cur_ofs += n*sizeof(REFLISTENTRY);
  if(mread_res(mr, cr, cur_ofs, 2, buf, &bytes)
     || bytes != 2)
    return 0;
  return reorderword(buf);
}

unsigned get_resource_size(MOUNT_RECORD *mr, CATALOG_RECORD *cr, 
			   LONGWORD type, resid_t id)
{
  unsigned long map_ofs, data_ofs, type_list_ofs, cur_ofs;
  LONGWORD bytes;
  unsigned n_types, i, n_res=0, res_data_ofs=0;
  unsigned char buf[10];

  if(mread_res(mr, cr, 0, 2*sizeof(LONGWORD), buf, &bytes)
     || bytes != 2*sizeof(LONGWORD))
    return 0;
  data_ofs = reorderlongword(buf);
  map_ofs = reorderlongword(buf+4);

  if(mread_res(mr, cr, map_ofs+24, 3*sizeof(WORD), buf, &bytes)
     || bytes != 3*sizeof(WORD))
    return 0;
  type_list_ofs = map_ofs+reorderword(buf);
  n_types = reorderword(buf+4)+1;

  cur_ofs = type_list_ofs+2;
  for(i=0; i<n_types; i++, cur_ofs += sizeof(TYPELISTENTRY)) {
    if(mread_res(mr, cr, cur_ofs, 8, buf, &bytes)
       || bytes != 8)
      return 0;
    if(*(LONGWORD *)buf==type) {
      n_res = reorderword(buf+4)+1;
      cur_ofs = type_list_ofs+reorderword(buf+6);
      break;
    }
  }
  if(i==n_types) return 0;

  for(i=0; i<n_res; i++, cur_ofs+=sizeof(REFLISTENTRY)) {
    if(mread_res(mr, cr, cur_ofs, 8, buf, &bytes) || bytes != 8)
      return 0;
    if((short)reorderword(buf)==id) {
      res_data_ofs = data_ofs+reorderword(buf+6)+(buf[5]<<16);
      break;
    }
  }
  if(i==n_res) return 0;

  if(mread_res(mr, cr, res_data_ofs, 4, buf, &bytes)
     || bytes != 4)
    return 0;
  return reorderlongword(buf);
}

int get_resource(MOUNT_RECORD *mr, CATALOG_RECORD *cr, 
		 LONGWORD type, resid_t id, char *dest)
{
  unsigned long map_ofs, data_ofs, type_list_ofs, cur_ofs;
  LONGWORD bytes;
  unsigned n_types, i, n_res=0, res_data_ofs=0, size;
  unsigned char buf[10];

  if(mread_res(mr, cr, 0, 2*sizeof(LONGWORD), buf, &bytes)
     || bytes != 2*sizeof(LONGWORD))
    return 0;
  data_ofs = reorderlongword(buf);
  map_ofs = reorderlongword(buf+4);

  if(mread_res(mr, cr, map_ofs+24, 3*sizeof(WORD), buf, &bytes)
     || bytes != 3*sizeof(WORD))
    return 0;
  type_list_ofs = map_ofs+reorderword(buf);
  n_types = reorderword(buf+4)+1;

  cur_ofs = type_list_ofs+2;
  for(i=0; i<n_types; i++, cur_ofs += sizeof(TYPELISTENTRY)) {
    if(mread_res(mr, cr, cur_ofs, 8, buf, &bytes)
       || bytes != 8)
      return 0;
    if(*(LONGWORD *)buf==type) {
      n_res = reorderword(buf+4)+1;
      cur_ofs = type_list_ofs+reorderword(buf+6);
      break;
    }
  }
  if(i==n_types) return 0;

  for(i=0; i<n_res; i++, cur_ofs+=sizeof(REFLISTENTRY)) {
    if(mread_res(mr, cr, cur_ofs, 8, buf, &bytes) || bytes != 8)
      return 0;
    if((short)reorderword(buf)==id) {
      res_data_ofs = data_ofs+reorderword(buf+6)+(buf[5]<<16);
      break;
    }
  }
  if(i==n_res) return 0;

  if(mread_res(mr, cr, res_data_ofs, 4, buf, &bytes)
     || bytes != 4)
    return 0;
  size = reorderlongword(buf);
  if(mread_res(mr, cr, res_data_ofs+4, size, dest, &bytes) || bytes != size)
    return 0;
  return size;
}
