#define NODEBUG

#include "../defs.h"
#include "../mountrec.h"
#include "local_btree.h"
#include "../errors.h"
#ifdef DEBUG
#include <stdio.h>
#include <ctype.h>
#endif


#define  LONGWORDTAG     0xFFFFFFFF
#define  BYTETAG         0xFE
#define  WORDTAG         0xFFFF 

#define  RETURN(err)    {Debug();return(err);}

typedef struct {
  LONGWORD BLink;
  LONGWORD FLink;
  LONGWORD Nodes;
  LONGWORD Records;
  BT_KEY   Key;
} CHECK_STACK_ELEM;



static  void Debug(void);


					/* Return - 0 - no error */
					/*          1 - Flink bad */
					/*          2 - Blink bad */
					/*          3 - Type bad */
					/*          4 - Height bad */
					/*          5 - NRecs bad */
					/*          6 - Not mapped */
					/*          7 - Read error */
					/*          8 - Number not valid*/

static int CheckNode(MOUNT_RECORD *mnt,
		     BT_HEADER *head,
		     int node,
		     BYTE* buff,
		     BYTE* buff_aux,
		     LONGWORD* Flink,
		     LONGWORD* BLink,
		     BYTE*     Type,
		     BYTE*     Height,
                     WORD*     NRecs);

static int RecurseTree(MOUNT_RECORD *mnt,
		       BT_HEADER *head,
		       LONGWORD root,
		       BYTE level,
		       CHECK_STACK_ELEM *stack,
		       BYTE *buff,
		       BYTE *buff_aux);





int  CheckFsBtree(MOUNT_RECORD *mnt,
		  BT_HEADER    *head,
		  int iscat)   {

  int err,i;
  CHECK_STACK_ELEM stack[8], *p_stack;
  LONGWORD nodes, FLink, BLink;
  BYTE Type, Height, n;
  int base, len_node,free,to_read;
  int mapnodes;
  BYTE *bitmap,mask;
  WORD NRecs;
  BYTE buff[BT_NODESIZE];
  BYTE buff_aux[BT_NODESIZE];

#ifdef DEBUG
  printf("Checking %s BTree\n", iscat ? "catalog" : "extents");
#endif

					/* Flush the header node */

  BT_WriteHeader(mnt, head, buff);

					/* Read and write the header node */
  FLink = LONGWORDTAG;
  BLink = 0;
  Type  = NODE_HEADER;
  Height= 0;
  NRecs = 3;
  err = CheckNode(mnt,head,0,buff, buff_aux, &FLink,&BLink,&Type, &Height,
		  &NRecs);
  if(err)

    RETURN(BT_CHECK - err);		/* 1 -- 8 */

					/* Verify the node size and key */
					/* length */
  if( GetWord(& buff[BTH_NODESIZE + 14]) != BT_NODESIZE)
    RETURN(BT_CHECK - 10);

  if( GetWord(& buff[BTH_NODESIZE + 14]) != head->bth.bthNodeSize)
    RETURN(BT_CHECK - 11);


  if( GetWord(& buff[BTH_KEYLEN + 14]) != (iscat ? 37 : 7) )
    RETURN(BT_CHECK - 12);

  if( GetWord(& buff[BTH_KEYLEN + 14]) != head->bth.bthKeyLen )
    RETURN(BT_CHECK - 13);

					/* Number of nodes */

  if( GetLongWord(& buff[BTH_NNODES +14]) != head->bth.bthNNodes )
    RETURN(BT_CHECK - 14);

  if( GetWord(& buff[BTH_DEPTH + 14]) != head->bth.bthDepth )
    RETURN(BT_CHECK - 15);

  if( GetLongWord(& buff[BTH_ROOT + 14]) != head->bth.bthRoot )
    RETURN(BT_CHECK - 16);

  if( GetLongWord(& buff[BTH_NRECS + 14]) != head->bth.bthNRecs )
    RETURN(BT_CHECK - 17);

  if( GetLongWord(& buff[BTH_FNODE + 14]) != head->bth.bthFNode )
    RETURN(BT_CHECK - 18);

  if( GetLongWord(& buff[BTH_LNODE + 14]) != head->bth.bthLNode )
    RETURN(BT_CHECK - 19);

  if( GetLongWord(& buff[BTH_FREE + 14]) != head->bth.bthFree )
    RETURN(BT_CHECK - 20);



  if( (nodes = GetLongWord(& buff[BTH_NNODES + 14])) * BT_NODESIZE != 
     (iscat ? mnt->vib.CTFlSize : mnt->vib.XTFlSize))
    RETURN(BT_CHECK - 21);  

#ifdef DEBUG
  printf("Header:\n");
  printf("  Depth = %x\n", head->bth.bthDepth);
  printf("  Root  = %x\n", head->bth.bthRoot);
  printf("  NRecs = %x\n", head->bth.bthNRecs);
  printf("  FNode = %x\n", head->bth.bthFNode);
  printf("  LNode = %x\n", head->bth.bthLNode);
  printf("  NSize = %x\n", head->bth.bthNodeSize);
  printf("  KLen  = %x\n", head->bth.bthKeyLen);
  printf("  NNodes= %x\n", head->bth.bthNNodes);
  printf("  Free  = %x\n", head->bth.bthFree);

  printf("Check the bitmap\n");
#endif



					/* Count the bitmap */
  base = 0;
  free = nodes;
  mapnodes = 0;

  do  {
					/* Read in the bitmap */
    if(base == 0) {
      bitmap = head->bth.btMap;
      len_node = 256;
    }
    else {

      if(base == 256*8)			/* First map */
	to_read = head->bth.bthAddMap;
      else
	to_read = GetLongWord(& buff[ND_FLINK]);
					/* Read and Verify it */
      FLink = LONGWORDTAG;
      BLink = 0;
      Type  = NODE_MAP;
      Height=0;
      NRecs =1;
      err = CheckNode(mnt,head,to_read, buff, buff_aux,
		      &FLink,&BLink,&Type,&Height,&NRecs);
      if(err)
	RETURN(BT_CHECK - 30 - err);	/* 31 -> 38 */
      
      if(to_read == 0)			/* Because CheckNode doesn't check */
	RETURN(BT_CHECK - 30 - 8);

      mapnodes++;

      bitmap = & buff[14];
      len_node = 494;
    }
					/* Count the bits in this node */
    for(i=0;i<len_node;i++)
      for(n = bitmap[i], mask = 0x80; n ; n <<= 1)
	if( n & 0x80)
	  free--;

    base += (len_node * 8);

  } while ( base < nodes);


  if(free != head->bth.bthFree)
    RETURN(BT_CHECK - 40);


  if(head->bth.bthDepth > BT_MAX_DEPTH)
    RETURN(BT_CHECK - 41);

					/* Init the stack */
  for(i=0,p_stack=stack;i< BT_MAX_DEPTH; i++, p_stack++) {
    p_stack->BLink=0;
    p_stack->FLink=0;
    p_stack->Nodes=0;
    p_stack->Records=0;
    bzero(p_stack, sizeof(CHECK_STACK_ELEM));
  }

#ifdef DEBUG
  printf("Recurse Tree\n");
#endif
  

					/* Will verify that the leaf */
  stack[1].FLink = head->bth.bthFNode;

  if(head->bth.bthRoot != 0 ) {
    err = RecurseTree(mnt, head, head->bth.bthRoot, head->bth.bthDepth, stack,
		      buff, buff_aux);
    if(err)				/* 50 -- 73*/
      return(err);
  }
					/* Now verify that all the levels */
					/* finish with FLink = 0 */
  for(i=0; i < BT_MAX_DEPTH; i++)
    if(stack[i].FLink != 0)
      RETURN(BT_CHECK - 74);

					/* Verify the last leaf */
  if(stack[1].BLink != head->bth.bthLNode)
    RETURN(BT_CHECK - 75);

					/* Verify the number of leaves */
  if(stack[1].Records != head->bth.bthNRecs)
    RETURN(BT_CHECK - 76);

					/* Verify the number of used nodes */
  for(i=0; i < BT_MAX_DEPTH; i++)
    mapnodes += stack[i].Nodes;

  if(mapnodes + 1 != head->bth.bthNNodes - head->bth.bthFree)
    RETURN(BT_CHECK - 77);

  return(0);				/* BTree -- Ok */
}



static int RecurseTree(MOUNT_RECORD *mnt,
		       BT_HEADER *head,
		       LONGWORD root,
		       BYTE level,
		       CHECK_STACK_ELEM *stack,
		       BYTE *buff,
		       BYTE *buff_aux)   {
  int i, err;
  LONGWORD FLink,BLink;
  BYTE Type, Height;
  WORD NRecs;
  BYTE *p_offset, *p_rec;
#ifdef DEBUG
  int len, j;
#endif

					/* Verifies that he is the next for */
					/* this level (i.e. equal to the */
					/* FLink of the last node on this*/
					/* level */
#ifdef DEBUG
  printf("Beginning the tree at ******* %x\n", root);
#endif

  if(stack[level].FLink != 0) {
    if(stack[level].FLink != root)
      RETURN(BT_CHECK - 50);
  }
					/* Read and Verifies the node */
  FLink = LONGWORDTAG;
  BLink = stack[level].BLink;
  Type  = BYTETAG;
  Height= level;
  NRecs = WORDTAG;
  err = CheckNode(mnt, head, root, buff, buff_aux, &FLink, &BLink,
		  &Type, &Height, &NRecs);

  if(err)
    RETURN(BT_CHECK - 60 - err);	/* 61 -- 68 */

  if(root == 0)				/* Because CheckNode doesn't check */
    RETURN(BT_CHECK - 60 - 8);

  if(level == 1 && Type != NODE_LEAF)
    RETURN(BT_CHECK - 70);

  if(Type == NODE_MAP)
    RETURN(BT_CHECK - 71);


					/* Compare the key */
					/* Adjust stack[level] */
  stack[level].Nodes++;
  stack[level].FLink = FLink;
  stack[level].BLink = root;

  p_offset = & buff[btnOffsetRec(0)];
  for(i = NRecs; i> 0; i--)  {

#ifdef DEBUG
  printf("Record %x in node %x\n", NRecs-i, root);
#endif
    
    p_rec = & buff[GetWord(p_offset)]; /* The next record */
    p_offset -=2;

#ifdef DEBUG
  printf("  Offset %lx \n", p_rec-buff);
  printf("  Key = \n");
  printf("\tLength = %x\n  ", (len = *p_rec));
  for(j=0;j<=len;j++)
    printf(isalnum(*(p_rec+j)) ? "%c " :"%x ", *(p_rec+j));
  printf("\n");
#endif

    
    stack[level].Records++;
					/* Verify that the father had the */
					/* same key*/
    if( i == NRecs && level + 1 < BT_MAX_DEPTH && * stack[level+1].Key)
      if((*head->KeyCmp)(stack[level+1].Key, p_rec))
	RETURN(BT_CHECK - 72);

    if(* stack[level].Key) {		/* If there is a prec. key on the */
					/* same level*/
      err = (*head->KeyCmp)(stack[level].Key, p_rec);
      if(err != -1)
	RETURN(BT_CHECK - 73);		/* This one should be greater */
    }
					/* Refresh the key */
    bcopy(p_rec, stack[level].Key, KeyLength(p_rec));

    if (Type == NODE_INDEX) {		/* Now recurse */
      err = RecurseTree(mnt, head, GetLongWord(& p_rec[KeyLength(p_rec)]),
		      level - 1, stack, buff, buff_aux);
      if(err)
	return(err);
					/* Refresh the buffer */
      err = BT_ReadNode(mnt, head, root, buff);
      if(err)
	return(err);
    }
  }
#ifdef DEBUG
  printf("Free space in node %x begins at %x\n", root, GetWord(p_offset));
  printf("One level up -----\n");
#endif
  
  return(0);
}



					/* Return - 0 - no error */
					/*          1 - Flink bad */
					/*          2 - Blink bad */
					/*          3 - Type bad */
					/*          4 - Height bad */
					/*          5 - NRecs bad */
					/*          6 - Not mapped */
					/*          7 - Read error */
					/*          8 - Number not valid*/
static int CheckNode(MOUNT_RECORD *mnt,
		     BT_HEADER *head,
		     int node,
		     BYTE* buff,
		     BYTE* buff_aux,
		     LONGWORD* FLink,
		     LONGWORD* BLink,
		     BYTE*     Type,
		     BYTE*     Height,
                     WORD*     NRecs)   {

  LONGWORD lw;
  WORD w;
  BYTE b;

#ifdef DEBUG
  printf("Checking node ------------ %x\n", node);
#endif

					/* Validate the number */
  if(node >= head->bth.bthNNodes)
    return (8);


  					/* Verify that the node is mapped */
  if(BT_BitMapNodeBusy(mnt, head, node, buff_aux) <= 0)
    return(6);

  if(BT_ReadNode(mnt, head, node, buff))
    return(7);

  lw = GetLongWord(& buff[ND_FLINK]);

#ifdef DEBUG
  printf("  FLink = %x\n", lw);
#endif

  if(*FLink == LONGWORDTAG) 
    *FLink = lw;
  else {
    if(*FLink != lw)
      return(1);
  }

  
  lw = GetLongWord(& buff[ND_BLINK]);
#ifdef DEBUG
  printf("  BLink = %x\n", lw);
#endif
  if(*BLink == LONGWORDTAG) 
    *BLink = lw;
  else {
    if(*BLink != lw) 
      return(2);
   
  }

  b = GetByte(& buff[ND_TYPE]);
#ifdef DEBUG
  printf("  Type = %x\n", b);
#endif

  if(node == 0) {
    if( b != NODE_HEADER)
      return(3);
  } else {
    if(b != NODE_INDEX && b!= NODE_MAP && b!= NODE_LEAF)
      return(3);
  }
  if(*Type == BYTETAG) 
    *Type = b;
  else {
    if(*Type != b)
      return(3);
  }

  b = GetByte(& buff[ND_HEIGHT]);
#ifdef DEBUG
  printf("  Height = %x\n", b);
#endif
  if(*Height == BYTETAG) 
    *Height = b;
  else {
    if(*Height != b)
      return(4);
  }

  
  w = GetWord(& buff[ND_NRECS]);
#ifdef DEBUG
  printf("  NRecs = %x\n", w);
#endif
  if(*NRecs == WORDTAG) 
    *NRecs = w;
  else {
    if(*NRecs != w)
      return(5);
  }
  
  return 0;
}


static void Debug(void)  {

  return;
}






