#include "../defs.h"
#include "../errors.h"
#include "../Lock/lock.h"
#include "../mountrec.h"
#include "../DevSupport/readwrite.h"
#include "volinfo.h"
#include <string.h>
#include <stdlib.h>

int readvolinfo(MOUNT_RECORD *mr)
{
  BYTE *buf;
  BYTE *t;

  if ((buf=(BYTE *) malloc(mr->sr.sectsize))==NULL)
    return READVIOUTOFMEM;


  lock(mr->viblock);

  if (readsects(mr, (SECTNUMTYPE) 2, 1, buf)!=1)  {
    free(buf);
    unlock(mr->viblock);
    return READVIFAILED;
  }

  t=buf;

  
  mr->vib.SigWord=reorderword(t);t+=2;     
  mr->vib.CrDate=reorderlongword(t);t+=4;      
  mr->vib.LsMod=reorderlongword(t);t+=4;      
  mr->vib.Atrb=reorderword(t);t+=2;        
  mr->vib.NmFls =reorderword(t); t+=2;     
  mr->vib.VBMSt=reorderword(t); t+=2;      
  mr->vib.AllocPtr=reorderword(t);t+=2;    
  mr->vib.NmAlBlks=reorderword(t);t+=2;    
  mr->vib.AlBlkSiz=reorderlongword(t);t+=4;   
  mr->vib.ClpSiz=reorderlongword(t);t+=4;     
  mr->vib.AlBlSt=reorderword(t); t+=2;    
  mr->vib.NxtCNID=reorderlongword(t);t+=4;    
  mr->vib.FreeBks=reorderword(t);t+=2;    
  mr->vib.VNlen=*t++;
  memcpy(mr->vib.VN, t, VOLNAMELEN);
  t+=VOLNAMELEN;
  mr->vib.VolBkUp=reorderlongword(t);t+=4;    
  mr->vib.VSeqNum=reorderword(t); t+=2;   
  mr->vib.WrCnt=reorderlongword(t);t+=4;      
  mr->vib.XTClpSiz=reorderlongword(t);t+=4;  
  mr->vib.CTClpSiz=reorderlongword(t);t+=4;   
  mr->vib.NmRtDirs=reorderword(t);t+=2;   
  mr->vib.FilCnt=reorderlongword(t);t+=4;      
  mr->vib.DirCnt=reorderlongword(t);t+=4;      
  memcpy(mr->vib.FndrInfo, t, FINDERINFOLEN);
  t+=FINDERINFOLEN;
  mr->vib.VCSize=reorderword(t);t+=2;      
  mr->vib.VCBMSize=reorderword(t);t+=2;    
  mr->vib.CtlCSize=reorderword(t);t+=2;    
  mr->vib.XTFlSize=reorderlongword(t);t+=4;
  
  mr->vib.XTExtRec[0].first=reorderword(t);t+=2;
  mr->vib.XTExtRec[0].length=reorderword(t);t+=2;
  mr->vib.XTExtRec[1].first=reorderword(t);t+=2;
  mr->vib.XTExtRec[1].length=reorderword(t);t+=2;
  mr->vib.XTExtRec[2].first=reorderword(t);t+=2;
  mr->vib.XTExtRec[2].length=reorderword(t);t+=2;
  
  mr->vib.CTFlSize=reorderlongword(t);t+=4;   
  
  mr->vib.CTExtRec[0].first=reorderword(t);t+=2;
  mr->vib.CTExtRec[0].length=reorderword(t);t+=2;
  mr->vib.CTExtRec[1].first=reorderword(t);t+=2;
  mr->vib.CTExtRec[1].length=reorderword(t);t+=2;
  mr->vib.CTExtRec[2].first=reorderword(t);t+=2;
  mr->vib.CTExtRec[2].length=reorderword(t);t+=2;

  free(buf);

#ifdef IFS
  mr->sr.volinfo_dirty = 0;
#endif

  if (mr->vib.SigWord!=0x4244) {
    unlock(mr->viblock);
    return NOTHFSDISK;
  } else {
    unlock(mr->viblock);
    return 0;
  }
}


int writevolinfo(MOUNT_RECORD *mr)
{
  BYTE *buf;
  BYTE *t;

#ifdef IFS
  if(!mr->sr.volinfo_dirty)
    return 0;
#endif

  if ((buf=(BYTE*)malloc(mr->sr.sectsize))==NULL) 
    return WRITEVIOUTOFMEM; 

/* First, read the current volinfo block in so that we don't
   change anything in the sector beyond the first 168 odd bytes.
*/

  if (readsects(mr, (SECTNUMTYPE) 2, 1, (char *) buf)!=1)  {
    free(buf);
    return READVIFAILED;
  }

/* Now overwrite the buffer with our in memory structure */

#ifdef USER
  lock(mr->viblock);
#endif
  
  reorderwordintobuf(buf,0,mr->vib.SigWord);
  reorderlongwordintobuf(buf,2,mr->vib.CrDate);
  reorderlongwordintobuf(buf,6,mr->vib.LsMod);
  reorderwordintobuf(buf,10,mr->vib.Atrb);
  reorderwordintobuf(buf,12,mr->vib.NmFls);
  reorderwordintobuf(buf,14,mr->vib.VBMSt);
  reorderwordintobuf(buf,16,mr->vib.AllocPtr);
  reorderwordintobuf(buf,18,mr->vib.NmAlBlks);
  reorderlongwordintobuf(buf,20,mr->vib.AlBlkSiz);
  reorderlongwordintobuf(buf,24,mr->vib.ClpSiz);
  reorderwordintobuf(buf,28,mr->vib.AlBlSt);
  reorderlongwordintobuf(buf,30,mr->vib.NxtCNID);
  reorderwordintobuf(buf,34,mr->vib.FreeBks);
  buf[36]=mr->vib.VNlen;
  memcpy(&(buf[37]), mr->vib.VN, VOLNAMELEN);
  reorderlongwordintobuf(buf,37+VOLNAMELEN,mr->vib.VolBkUp);
  reorderwordintobuf(buf,37+VOLNAMELEN+4,mr->vib.VSeqNum);
  reorderlongwordintobuf(buf,37+VOLNAMELEN+6,mr->vib.WrCnt);
  reorderlongwordintobuf(buf,37+VOLNAMELEN+10,mr->vib.XTClpSiz);
  reorderlongwordintobuf(buf,37+VOLNAMELEN+14,mr->vib.CTClpSiz);
  reorderwordintobuf(buf,37+VOLNAMELEN+18,mr->vib.NmRtDirs);
  reorderlongwordintobuf(buf,37+VOLNAMELEN+20,mr->vib.FilCnt);
  reorderlongwordintobuf(buf,37+VOLNAMELEN+24,mr->vib.DirCnt);
  memcpy(&(buf[37+VOLNAMELEN+28]),mr->vib.FndrInfo,FINDERINFOLEN);
  reorderwordintobuf(buf,37+VOLNAMELEN+28+FINDERINFOLEN,mr->vib.VCSize);
  reorderwordintobuf(buf,37+VOLNAMELEN+28+FINDERINFOLEN+2,mr->vib.VCBMSize);
  reorderwordintobuf(buf,37+VOLNAMELEN+28+FINDERINFOLEN+4,mr->vib.CtlCSize);
  reorderlongwordintobuf(buf,37+VOLNAMELEN+28+FINDERINFOLEN+6,
			 mr->vib.XTFlSize);
  
  reorderwordintobuf(buf,37+VOLNAMELEN+28+FINDERINFOLEN+10,
		     mr->vib.XTExtRec[0].first);
  reorderwordintobuf(buf,37+VOLNAMELEN+28+FINDERINFOLEN+12,
		     mr->vib.XTExtRec[0].length);
  reorderwordintobuf(buf,37+VOLNAMELEN+28+FINDERINFOLEN+14,
		     mr->vib.XTExtRec[1].first);
  reorderwordintobuf(buf,37+VOLNAMELEN+28+FINDERINFOLEN+16,
		     mr->vib.XTExtRec[1].length);
  reorderwordintobuf(buf,37+VOLNAMELEN+28+FINDERINFOLEN+18,
		     mr->vib.XTExtRec[2].first);
  reorderwordintobuf(buf,37+VOLNAMELEN+28+FINDERINFOLEN+20,
		     mr->vib.XTExtRec[2].length);
  
  reorderlongwordintobuf(buf,37+VOLNAMELEN+28+FINDERINFOLEN+22,
		     mr->vib.CTFlSize);

  reorderwordintobuf(buf,37+VOLNAMELEN+28+FINDERINFOLEN+26,
		     mr->vib.CTExtRec[0].first);
  reorderwordintobuf(buf,37+VOLNAMELEN+28+FINDERINFOLEN+28,
		     mr->vib.CTExtRec[0].length);
  reorderwordintobuf(buf,37+VOLNAMELEN+28+FINDERINFOLEN+30,
		     mr->vib.CTExtRec[1].first);
  reorderwordintobuf(buf,37+VOLNAMELEN+28+FINDERINFOLEN+32,
		     mr->vib.CTExtRec[1].length);
  reorderwordintobuf(buf,37+VOLNAMELEN+28+FINDERINFOLEN+34,
		     mr->vib.CTExtRec[2].first);
  reorderwordintobuf(buf,37+VOLNAMELEN+28+FINDERINFOLEN+36,
		     mr->vib.CTExtRec[2].length);
  
  if (writesectsunbuf(mr,(SECTNUMTYPE) 2, 1, (char *) buf)!=1) {
    unlock(mr->viblock);
    free(buf);
    return WRITEVIFAILED;
  }

  free(buf);

#ifdef IFS
  mr->sr.volinfo_dirty = 0;
#endif

#ifdef USER
  unlock(mr->viblock);
#endif
  return 0;
}
