/*********************************************************************/
/* REXXCMD.SCR   GammaTech IRC Sample REXX Command Exit Script       */
/*********************************************************************/
/*                                                                   */
/* This is a sample REXX script for use with GammaTech IRC. It will  */
/* perform the following functions:                                  */
/*                                                                   */
/* 1) Provides a /REXXVAR command which can be used to set global    */
/*    REXX variables for use in the other script routines.           */
/* 2) Provides a /BOOT command a simplified version of /KICK         */
/* 3) Creates a /WHOM command which executes a /VERSION and a        */
/*    /USERINFO on the specified nickname.                           */
/*                                                                   */
/* Warning: Do not change this script. Copy it to another name       */
/* and modify the copy for backup purposes.                          */
/*                                                                   */
/*********************************************************************/
/*                                                                   */
/* Entry arguments:                                                  */
/*                                                                   */
/* Arg 1 - Window handle                                             */
/* Arg 2 - Current Nickname                                          */
/* Arg 3 - The command / text                                        */
/*                                                                   */
/* The command may be suppressed or ignored. To suppress             */
/* the command, return a null ("") string. To allow the command to   */
/* be processed normally, return a non-null string.                  */
/*                                                                   */
/*********************************************************************/
/*                                                                   */
/* There are  external REXX functions you may use in this REXX       */
/* procedure which are described below.                              */
/*                                                                   */
/* IrcRexxDisplay(text,win)  This function displays "text" in the    */
/* window. It does not send the text over IRC. The "text" parameter  */
/* is a null terminated string containing the text to display.       */
/*                                                                   */
/* The "win" parameter describes the window in which to display the  */
/* text. Use a null string to cause the text to be displayed in the  */
/* control window. To display the text in the window where           */
/* messages would normally be displayed, use the first argument      */
/* passed to this procedure.                                         */
/*                                                                   */
/* IrcRexxCommand(text,win)  This function sends "text" over IRC.    */
/* The "text" is a null terminated string containing the text to     */
/* be sent. The text may be text to the channel or a IRC command.    */
/*                                                                   */
/* The "win" parameter describes the window in which to display the  */
/* output of the text or command. Use a null string to cause the     */
/* output to be displayed in the control window. To display the      */
/* output in the window where messages would normally be             */
/* displayed, use the first argument passed to this procedure.       */
/*                                                                   */
/* IrcRexxSend(text)  This function sends the "text" as a raw        */
/* string directly to the server. A carriage return and line feed    */
/* is appended to the text before transmission.                      */
/*                                                                   */
/* IrcRexxWildCard(wildcard,string)  This function checks string     */
/* for a match against wildcard. If a match is found MATCH is        */
/* returned. If no match is found NOMATCH is returned.               */
/*                                                                   */
/*********************************************************************/
Parse Upper Arg Win Us Verb Parm1 Parms

Pool = 'OS2ENVIRONMENT'

/*********************************************************************/
/* We implement a /rexxvar command to set global rexx variables for  */
/* the scripts to examine for various purposes.                      */
/*********************************************************************/

if (Verb = '/REXXVAR' & Parm1 <> '') then do
   VALUE(Parm1,Parms,Pool)
   Return ""
end

/*********************************************************************/
/* If this is the "/boot" command we format and execute a /kick and  */
/* then suppress the original /boot command.                         */
/*                                                                   */
/* Note that the boot command must be activated via /rexxvar boot on */
/* before it can be used.                                            */
/*                                                                   */
/*********************************************************************/

if (Verb = '/BOOT' & Parm1 <> '' & VALUE('BOOT',,Pool) = 'ON') then do
   OutStr = "/KICK" Parm1 "Get out you lamer"
   IrcRexxCommand(OutStr,Win)
   Return ""
end

/*********************************************************************/
/* The /WHOM command simply executes a /VERSION and /USERINFO on the */
/* specified nickname.                                               */
/*                                                                   */
/* Syntax:  /WHOM nickname                                           */
/*                                                                   */
/*********************************************************************/

if (Verb = '/WHOM') then do
   if (Parm1 <> '') then do
      OutStr = "/VERSION "  Parm1
      IrcRexxCommand(OutStr,Win)
      OutStr = "/USERINFO " Parm1
      IrcRexxCommand(OutStr,Win)
   end

   else do
      IrcRexxDisplay("Syntax error",Win)
   end

   Return ""
end

/*********************************************************************/
/* This isn't a command we care about so we pass a non-null string   */
/* so that it will be processed normally.                            */
/*********************************************************************/

Return "OK"

