/* Configuration for an i386 running emx (target). */

/* We do want to add an underscore to the front of each user symbol. */
#define YES_UNDERSCORES

#include "i386/gstabs.h"

/* The system headers are C++-aware. */
#define NO_IMPLICIT_EXTERN_C

/* Paths. */
#define GCC_INCLUDE_DIR            "/emx/include"
#define GPLUSPLUS_INCLUDE_DIR      "/emx/include.gpp"
#define LOCAL_INCLUDE_DIR          "/usr/local/include"
#define CROSS_INCLUDE_DIR          "/emx/include.sys"
#define STANDARD_EXEC_PREFIX       "/emx/bin/"
#define STANDARD_STARTFILE_PREFIX  "/emx/lib/"

/* Target configuration name. */
#define DEFAULT_TARGET_MACHINE     "i386-unknown-emx"

/* Enable #pragma pack. */
#define HANDLE_SYSV_PRAGMA

/* wchar_t is unsigned short. */
#define WCHAR_TYPE              "short unsigned int"
#define WCHAR_TYPE_SIZE         16

/* Bitfields may cross alignment boundaries. */
#undef PCC_BITFIELD_TYPE_MATTERS
#define PCC_BITFIELD_TYPE_MATTERS 0

/* By default, return short structures in registers. */
#define DEFAULT_PCC_STRUCT_RETURN 0


/* Don't continue symbols.  I think all relevant tools can handle
   symbols of arbitrary length.  GAS does not correctly handle
   continued symbols: it sometimes emits another symbol before the
   continuation. */
#define DBX_CONTIN_LENGTH 0

/* The -Zstack option takes an argument. */
#define WORD_SWITCH_TAKES_ARG(STR) (DEFAULT_WORD_SWITCH_TAKES_ARG (STR) \
                                    || !strcmp (STR, "Zstack"))

/* Predefine symbols `__32BIT__', `__EMX__', and `i386'. */
#undef CPP_PREDEFINES
#define CPP_PREDEFINES "-D__32BIT__ -D__EMX__ -Di386\
  -Asystem(unix) -Asystem(emx) -Acpu(i386) -Amachine(i386)"

/* Predefine the symbol `__MT__' for multi-threaded programs (-Zmt).
   Pass -Zc++-comments and -ZC++-comments to the preprocessor. */
#undef CPP_SPEC
#define CPP_SPEC "%{posix:-D_POSIX_SOURCE} %{Zmt:-D__MT__} \
%{Zomf} %{ZC++-comments} %{Zc++-comments}"

/* Pass -Zomf and -s (as -Zstrip) to the assembler. */
#define ASM_SPEC "%{Zomf} %{s:-Zstrip}"

#define LINK_SPEC \
  "%{Zexe} %{Zstack*} %{Zmap*} %{Zomf:%{Zdll}}" \
  "%{!o*:-o %b.%{Zdll:dll}%{!Zdll:exe}} " \
  "%{static:%{Zcrtdll=*:%e-static and -Zcrtdll are incompatible}}" \
  "%{Zdll:%{Zexe:%e-Zdll and -Zexe are incompatible}}" \
  "%{Zso:%{!Zsys:%e-Zso requires -Zsys}}" \
  "%{Zso:%{!Zdll:%e-Zso requires -Zdll}}" \
  "%{Zno-rte:%{!Zdll:%e-Zno-rte requires -Zdll}}" \
  "%{Zno-rte:%{!Zomf:%e-Zno-rte requires -Zomf}}" \
  "%{Zno-rte:%{Zsys:%e-Zno-rte and -Zsys are incompatible}}" \
  "%{Zno-rte:%{Zso:%e-Zno-rte and -Zso are incompatible}}" \
  "%{Zno-rte:%{Zcrtdll=*:%e-Zcrtdll and -Zno-rte are incompatible}}" \
  "%{Zno-rte:%{Zmt:%e-Zmt and -Zno-rte are incompatible}}" \
  "%{Zsys:%{Zcrtdll=*:%e-Zcrtdll and -Zsys are incompatible}}" \
  "%{Zsys:%{!Zomf:%e-Zsys requires -Zomf}}" \
  "%{Zsys:%{Zbsd-signals:%e-Zbsd-signals and -Zsys are incompatible}}" \
  "%{Zsys:%{Zsysv-signals:%e-Zsysv-signals and -Zsys are incompatible}}" \
  "%{Zbsd-signals:%{Zsysv-signals:%e-Zbsd-signals and -Zsysv-signals are incompatible}}"

#define LIBGCC_SPEC "-lgcc"

#define LIB_SPEC \
  "%{g*:-lg} " \
  "%{!p:%{!pg:-lc " \
    "%{Zdll:%{Zso:-lc_dllso}%{Zno-rte:-lc_dllnrt}" \
           "%{!Zso:%{!Zno-rte:-lc_dllrt}}}" \
    "%{!Zdll:-lc_app} -lc }}" \
  "%{p:-lc_p}%{pg:-lc_p}"

#define STARTFILE_SPEC \
  "%{Zdll:dll0%O%s}" \
  "%{!Zdll:%{pg:gcrt0%O%s}%{!pg:%{p:mcrt0%O%s}%{!p:crt0%O%s}}" \
         " %{Zsysv-signals:sigsysv%O%s} %{Zbsd-signals:sigbsd%O%s}" \
         " %{Zbin-files:binmode%O%s}}"


/* Stack probes */

#define MASK_PROBE		000100000000	/* Generate stack probes */

#undef SUBTARGET_SWITCHES
#define SUBTARGET_SWITCHES  \
    { "probe", MASK_PROBE},				\
    { "no-probe", -MASK_PROBE},

/* Use a stack probe */
#define TARGET_PROBE (target_flags & MASK_PROBE)

#define PROBE_SIZE         0x1000
#define PROBE_MAX_INLINE   0x10000

/* Output assembler code to FILE to increment profiler label # LABELNO
   for profiling a function entry.  */

#undef FUNCTION_PROFILER
#define FUNCTION_PROFILER(FILE, LABELNO)  \
{									\
  fprintf (FILE, "\tpushl $%sP%d\n", LPREFIX, (LABELNO));		\
  fprintf (FILE, "\tcall __mcount\n");					\
  fprintf (FILE, "\taddl $4,%%esp\n");					\
}

#define PROFILE_BEFORE_PROLOGUE

/* Calling conventions */

#undef VALID_MACHINE_TYPE_ATTRIBUTE
#define VALID_MACHINE_TYPE_ATTRIBUTE(TYPE, ATTRIBUTES, NAME, ARGS) \
  (emx_valid_type_attribute_p (TYPE, ATTRIBUTES, NAME, ARGS))

#undef RETURN_POPS_ARGS
#define RETURN_POPS_ARGS(FUNDECL,FUNTYPE,SIZE) \
  (emx_return_pops_args (FUNDECL, FUNTYPE, SIZE))
