/****************************************************************************

    Module  : FreeDock.h

*****************************************************************************/

#define VersionText "v2.03"


#ifdef  WIN32
#define OS_Bits "(32 Bit)"
#else
#define OS_Bits "(16 Bit)"
#endif

#define STRICT

/*******************************************************************************
    Include file with data defs for dock program
*******************************************************************************/

#define DOCK_MAX_SIZE       32     // Max number of slots
#define DEFAULT_DOCK_SIZE   10     // defualt number of slots (if not in .ini)

// typedef enum( SLOT_FREE,
// 			  SLOT_USED,
// 			  SLOT_SPECIAL_TITLE,
// 			  SLOT_SPECIAL_EXIT,
// 			  SLOT_SPECIAL_CLOCK,
// 			  SLOT_SPECIAL_MAIL,
// 			  SLOT_SPECIAL_CHILD
// )SLOT_TYPE;

// typedef enum( START_MINIMUM,
// 			  START_MAXIMUM,
// 			  START_NORMAL,
// 			  START_STORE
// )START_TYPE;

// typedef enum( DOCK_HORZ,
// 			  DOCK_VERT
// )DOCK_POS;

#define SLOT_FREE           0      // Slot is being used
#define SLOT_USED           1      // slot is empty
#define SLOT_SPECIAL_TITLE  10     // slot is a special slot type (Tile Icon)
#define SLOT_SPECIAL_EXIT   11     // slot is a special slot type (Exit Windows)
#define SLOT_SPECIAL_CLOCK  12     // slot is a special slot type (Clock slot)
#define SLOT_SPECIAL_MAIL   13     // slot is a special slot type (Mail Check)
#define SLOT_SPECIAL_CHILD  14     // slot is a special slot type (Has a child dock)

#define START_MINIMUM       0
#define START_MAXIMUM       1
#define START_NORMAL        2
#define START_STORE         3
#define START_ONTOP         4

#define MAX_FPATH_LEN       128    // Max length of a path
#define TMP_BUFF_LEN        32     // Length of temp string buffer in main
#define MAX_CMDLINE_LEN     1024   // Max len of command line

#define SLOT_BUTTON_WIDTH   38     // 32x32 icon + border of 3 on each side
#define SLOT_BUTTON_HEIGHT  38     // ditto

#define ICON_WIDTH          32     // Temporary definitions of Icon size,
#define ICON_HEIGHT         32     // these should be replaced by sysinfo() data

#define DOCK_HORZ           0      // Dock Orientation
#define DOCK_VERT           1      //

#define DEF_STORE_X         0       // Initial non-fatal values for
#define DEF_STORE_Y         0       // stored window position, incase
#define DEF_STORE_W       400       // user selects "stored" without
#define DEF_STORE_H       200       // then grabbing a window

#define MAIL_TIMER	    1	    	// Timer ID for the mail checking slot

#define DEFAULT_WIN_W	200 	    // Default window widths & heights
#define DEFAULT_WIN_H   100			// for the stored window pos of a slot


/******************************************************************
    Data structure to hold all data relating to a single slot 
******************************************************************/

typedef struct _SLOT_ENTRY{
    int         SlotType;                   // type of the slot
    int         ID;                         // Slot ID Number
    char        AppName[MAX_FPATH_LEN];     // Application pathname
    char        CmdLine[MAX_CMDLINE_LEN];   // Application command line
    char        RunTimeDir[MAX_FPATH_LEN];  // Application Runtime dir
    int         StartState;                 // Application Start State (normal/min/max)
    BOOL        StartOnTop;                 // Application started on top of others ?
    int         WinX;                       // Application window x position
    int         WinY;                       // Application window y position
    int         WinWidth;                   // Application window width
    int         WinHeight;                  // Application window height
    char        IconFile[MAX_FPATH_LEN];    // Application icon file name
    int         IconPos;                    // Position in file of app icon
    int         IconTotal;                  // Total Number of Icons in icon file
    int         IconIndex;                  // Index into the icon Cache
}SLOT_ENTRY;

/********************************************************************
    Data structure to hold main dock options
********************************************************************/

typedef struct _MAIN_OPTIONS{
    int  	Position;
    int  	DockSize;
    int  	DockLeft;
    int  	DockTop;
    BOOL 	ClockActive;
    BOOL 	WinExitActive;
    BOOL 	MailActive;
    BOOL 	MaxView;
    BOOL 	AlwaysOnTop;
    BOOL 	SingleClickStart;
    char 	MailPath[MAX_FPATH_LEN];
    int  	MailFreq;
    BOOL 	MailSound;
    long 	MailBoxSize;
    long 	MailBoxDateTime;
    BOOL	bMailInBox;
    BOOL 	WinExitConfirm;
    HBITMAP	hbmIconCache;                    // Handle to Icon Cache Bitmap
    HDC     hdcIconCache;                    // Handle to Icon Cache DC
}MAIN_OPTIONS;

/*********************************************************************
  Declarations for global variables accessible to all modules
*********************************************************************/
extern MAIN_OPTIONS DockOptions;
extern SLOT_ENTRY  *Slot;
extern SLOT_ENTRY   TmpSlot;
extern int          CurSlot;
extern char        *IniFile;
extern HANDLE	    hAppInst;
extern HWND         hwndDock;
extern int          gScreenWidth;
extern int          gScreenHeight;
extern int          gIconWidth;
extern int          gIconHeight;
extern int 	  	  	gDlgTitleHeight;
extern int 	  	  	gDlgFrameWidth;
extern int 	  	  	gDlgFrameHeight;

extern BOOL         bFoundWindow;

/**************************************************************************
 *  Declare function prototypes for all of the procs associated with a    *
 *  specific window.                                                      *
 **************************************************************************/
long FAR PASCAL DockWinProc(HWND, UINT, WPARAM, LPARAM);
int ReadINIFile( HWND hwnd, HANDLE hInst, SLOT_ENTRY *Slot);
int UpdateINIFile(SLOT_ENTRY *Slot);
void DrawBitmap(HDC hdc, HBITMAP hBitmap, int xStart, int yStart);
void PaintSlot( HDC hdc, int i );
void RePaintSlot( int i, BOOL bErase );
void BlankSlot( HDC hdc, int Slot );
BOOL IsCursorOutOfDock(int X, int Y);
int FindSlotHit( int DockPosition, int XHit, int YHit );
void SwapSlots( SLOT_ENTRY *Slot1, SLOT_ENTRY *Slot2 );

void SetDockWinPos( int DockPos );
void ExecSlot( int SlotHit, char *CmdLine );

void UtilLoadIcon( SLOT_ENTRY *Slot );
void UtilDrawIcon( HDC hdcDest, SLOT_ENTRY *Slot, int X, int Y );
void UtilEmptySlot( SLOT_ENTRY *Slot );
BOOL CALLBACK UtilSetupStartedWin( HWND hwnd, LPARAM hInst );

BOOL FAR PASCAL AppOptionsDlgProc(HWND hDlg, UINT iMessage,WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL MainOptionsDlgProc(HWND hDlg, UINT iMessage,WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL MailOptionsDlgProc(HWND hDlg, UINT iMessage,WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL WinExitOptionsDlgProc(HWND hDlg, UINT iMessage,WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL ClockOptionsDlgProc(HWND hDlg, UINT iMessage,WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL AboutDockDlgProc(HWND hDlg, UINT iMessage,WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL ChooseIconDlgProc(HWND hDlg, UINT iMessage, WPARAM wParam, LPARAM lParam);
BOOL FAR PASCAL PreviewerDlgProc(HWND hDlg, UINT iMessage, WPARAM wParam, LPARAM lParam);

BOOL FAR PASCAL fnAPPOPTIONSDLGDlgProc(HWND, UINT, WPARAM, LPARAM);

BOOL FAR PASCAL BrowseIconFile( HWND, char * );
BOOL FAR PASCAL BrowseFileName( HWND, char * );

/****************************************
 * Set definitions for the dialog items *
 ****************************************/

/***************************************************************
 * Definitions for the Dialog boxes                            *
 * These definitions must tie in with the values specified as  *
 * ID's in the resource file.								   *
 * These values are included from the resource header file     *
 ***************************************************************/

#include "resource.h"
