/****************************************************************************

    Module  : DrawBmp.c

    Version : v1.0alpha

    Date    : 20/8/93

    Changes : 20/8/93 - Added RePaintSlot Procedure


*****************************************************************************/

/****************************************************************************

    FUNCTION: DrawBitmap(HDC hdc, HBITMAP hBitmap, short xStart, short yStart)

    VERSION : v1.0

    PURPOSE : To draw the bitmap references by hBitmap, at the
              coordinated specified by (xStart,yStart), in the device
              context specified by hdc.

    PARAMETERS:  hdc - Handle to the device context in which the bitmap
                       is to be drawn.
                 hBitmap - Handle for the bitmap to be drawn.
                 xStart - X coordinate (upper left corner) of the bitmap
                 yStart - Y coordinate (lower right corner) of the bitmap

    COMMENTS:

****************************************************************************/


#include <windows.h>            /* include standard windows header */
#include "freedock.h"

void DrawBitmap(HDC hdc, HBITMAP hBitmap, int xStart, int yStart)
{
    BITMAP          bm;         /* Bitmap structure, used to find dimensions
                                 * of bitmap to be drawn */
    HDC             hdcMem;     /* Handle to a Memory device context, ie an
                                 * area of memory into which the bitmap can
                                 * be fetched, before being drawn */
    POINT           ptSize;     /* a point struct to contain the bitmap size */
    POINT           ptOrg;      /* a point struct to contain the origin of
                                 * the bitmap in the hdcMem */

    hdcMem = CreateCompatibleDC(hdc);   /* create memory storage for the
                                         * bitmap */
    SelectObject(hdcMem, hBitmap);      /* Select the bitmap into the memory
                                         * device context */

    SetMapMode(hdcMem, GetMapMode(hdc));        /* Set the mapping mode of
                                                 * the hdcMem to be the same
                                                 * as the destination device
                                                 * context */

    /*
     * load the bitmap into a Bitmap struct so the dimensions can be
     * determined
     */
    GetObject(hBitmap, sizeof(BITMAP), (LPSTR) & bm);

    ptSize.x = bm.bmWidth;      /* store the Width and height of the bitmap */
    ptSize.y = bm.bmHeight;
    DPtoLP(hdc, &ptSize, 1);    /* convert Device Points into Logical Points */

    ptOrg.x = 0;                /* set the origin of the source bitmap */
    ptOrg.y = 0;
    DPtoLP(hdcMem, &ptOrg, 1);  /* convert Device Points into Logical Points */

    /* Blit the source bitmap into the destination context */
    BitBlt(hdc, xStart, yStart, ptSize.x, ptSize.y, hdcMem, ptOrg.x, ptOrg.y,
        SRCCOPY);

	DeleteDC(hdcMem);           /* delete the memory context & free the
                                 * memory used */
}

void PaintSlot(HDC hdc, int i)
{
    if (i < 0 ) return;
    if (i >= DockOptions.DockSize) return;

    if (Slot[i].SlotType != SLOT_FREE) {
        if (DockOptions.Position == DOCK_HORZ) {
            UtilDrawIcon( hdc, &Slot[i], i*SLOT_BUTTON_WIDTH, 0 );
        } 
        else {
            UtilDrawIcon( hdc, &Slot[i], 0, i*SLOT_BUTTON_HEIGHT );
        }
    }
}

void RePaintSlot(int i, BOOL bErase)
{
    RECT            rect;

    if (i < 0 ) return;
    if (i >= DockOptions.DockSize) return;

    if (DockOptions.Position == DOCK_HORZ) {
        rect.top = 0;
        rect.left = (i * SLOT_BUTTON_WIDTH);
        rect.bottom = SLOT_BUTTON_HEIGHT;
        rect.right = (i * SLOT_BUTTON_WIDTH) + SLOT_BUTTON_WIDTH;
    } 
    else {
        rect.top = (i * SLOT_BUTTON_HEIGHT);
        rect.left = 0;
        rect.bottom = (i * SLOT_BUTTON_HEIGHT) + SLOT_BUTTON_HEIGHT;
		rect.right = SLOT_BUTTON_WIDTH;
    }

	InvalidateRect(hwndDock, &rect, bErase);
}


void BlankSlot( HDC hdc, int Slot ){

	RECT	rect;

	if (Slot < 0 ) return;
    if (Slot >= DockOptions.DockSize) return;

	if (DockOptions.Position == DOCK_HORZ) {
        rect.top = 0;
        rect.left = (Slot * SLOT_BUTTON_WIDTH);
        rect.bottom = SLOT_BUTTON_HEIGHT;
        rect.right = (Slot * SLOT_BUTTON_WIDTH) + SLOT_BUTTON_WIDTH;
    } 
    else {
        rect.top = (Slot * SLOT_BUTTON_HEIGHT);
        rect.left = 0;
		rect.bottom = (Slot * SLOT_BUTTON_HEIGHT) + SLOT_BUTTON_HEIGHT;
		rect.right = SLOT_BUTTON_WIDTH;
    }

	FillRect( hdc, &rect, GetStockObject(LTGRAY_BRUSH) );
}


/** Function to draw a button/Blank slot with the Icon on it **/
void UtilDrawIcon( HDC hdcDest, SLOT_ENTRY *Slot, int X, int Y ){

    static HBITMAP  hBlank = NULL;

    // Load up the blank image if we don't already have it
    if( hBlank == NULL ){
        hBlank = LoadBitmap(hAppInst, "SlotButton");
    }
                                      
	/** Draw the blank slot first **/                                      
    DrawBitmap(hdcDest, hBlank, X, Y);
    /** Now copy the relevant Icon from the IconCache **/
    BitBlt( hdcDest, X+3, Y + 3, gIconWidth, gIconHeight, 
            DockOptions.hdcIconCache, Slot->IconIndex, 0, SRCCOPY);
  
} 
