//
// $Header: D:/ext2-os2/RCS/fs_swap.c,v 1.1 1996/05/31 21:55:08 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to     
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM 
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.



#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>                // From the "Developer Connection Device Driver Kit" version 2.0

#include <fsd.h>
#include <fsh.h>

#include <os2/types.h>
#include <os2/os2proto.h>
#include <os2/errors.h>
#include <os2/log.h>

#if 0
extern char trace_FS_ALLOCATEPAGESPACE;
extern char trace_FS_DOPAGEIO;
extern char trace_FS_OPENPAGEFILE;
#endif
extern char trace_FS_SETSWAP;
#if 0
_FS_RET _FS_ENTRY FS_ALLOCATEPAGESPACE(
                                    struct sffsi _FS_PTR psffsi,       /* ptr to fs independent SFT */
                                    struct sffsd _FS_PTR psffsd,       /* ptr to fs dependent SFT         */
                                    unsigned long        ulSize,       /* new size                         */
                                    unsigned long        ulWantContig  /* contiguous chunk size         */
                                   )
{
    int rc;
    if (trace_FS_ALLOCATEPAGESPACE) {
        kernel_printf("FS_ALLOCATEPAGESPACE pre-invocation");
    }
    rc = ERROR_NOT_SUPPORTED;
    if (trace_FS_ALLOCATEPAGESPACE) {
        kernel_printf("FS_ALLOCATEPAGESPACE post-invocation - rc = %d", rc);
    }
    return rc;
}


_FS_RET _FS_ENTRY FS_DOPAGEIO(
                              struct sffsi         _FS_PTR psffsi,
                              struct sffsd         _FS_PTR psffsd,
                              struct PageCmdHeader _FS_PTR pPageCmdList
                             )
{
    int rc;
    if (trace_FS_DOPAGEIO) {
        kernel_printf("FS_DOPAGEIO pre-invocation");
    }
    rc = ERROR_NOT_SUPPORTED;
    if (trace_FS_DOPAGEIO) {
        kernel_printf("FS_DOPAGEIO post-invocation - rc = %d", rc);
    }
    return rc;
}


_FS_RET _FS_ENTRY FS_OPENPAGEFILE(
                                  unsigned long _FS_PTR pFlags,
                                  unsigned long _FS_PTR pcMaxReq,
                                  char          _FS_PTR pName,
                                  struct sffsi  _FS_PTR psffsi,
                                  struct sffsd  _FS_PTR psffsd,
                                  unsigned short        usOpenMode,
                                  unsigned short        usOpenFlag,
                                  unsigned short        usAttr,
                                  unsigned long         Reserved
                                 )
{
    int rc;

    if (trace_FS_OPENPAGEFILE) {
        kernel_printf("FS_OPENPAGEFILE(%s) pre-invocation", pName);
    }
    rc = ERROR_NOT_SUPPORTED;
    if (trace_FS_OPENPAGEFILE) {
        kernel_printf("FS_OPENPAGEFILE post-invocation - rc = %d", rc);
    }
    return rc;
}
#endif

_FS_RET _FS_ENTRY FS_SETSWAP(
                             struct sffsi _FS_PTR psffsi,
                             struct sffsd _FS_PTR psffsd
                            )
{
    int rc;
    if (trace_FS_SETSWAP) {
        kernel_printf("FS_SETSWAP pre-invocation");
    }
    rc = ERROR_NOT_SUPPORTED;
    if (trace_FS_SETSWAP) {
        kernel_printf("FS_SETSWAP post-invocation - rc = %d", rc);
    }
    return rc;
}
