//
// $Header: D:/ext2-os2/RCS/fs_cmmit.c,v 8.0 1996/05/31 00:22:21 Willm Exp Willm $
//

// Linux ext2 file system driver for OS/2 2.x and WARP - Allows OS/2 to     
// access your Linux ext2fs partitions as normal drive letters.
// Copyright (C) 1995, 1996 Matthieu WILLM 
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#define INCL_DOSERRORS
#define INCL_NOPMAPI
#include <os2.h>		// From the "Developer Connection Device Driver Kit" version 2.0

#include <fsd.h>
#include <fsh.h>


#include <os2/types.h>
#include <linux/fs.h>
#include <linux/fs_proto.h>
#include <os2/os2proto.h>
#include <os2/os2misc.h>
#include <os2/cdfsd.h>

extern char trace_FS_COMMIT;

/**********************************************************************************************/
/*** FS_COMMIT() : This is the IFS entry point for the DosResetBuffer() system call         ***/
/**********************************************************************************************/
_FS_RET _FS_ENTRY FS_COMMIT(
                            unsigned short         type,
                            unsigned short         IOflag,
                            struct sffsi   _FS_PTR psffsi,
                            struct sffsd   _FS_PTR psffsd
)
{
    int          rc;
    struct file *filp;

    if (trace_FS_COMMIT) {
        kernel_printf("FS_COMMIT pre-invocation : type = %d", type);
    }

    if (Read_Write) {
        if ((filp = ((_sffsd _FS_PTR)psffsd)->p_file)) {

            //
            // Do the time stamping stuff - We commit the time stamp to disk if both
            // ST_Sxxx and ST_Pxxx flags are set
            //
            if (psffsi->sfi_tstamp & ST_PCREAT) {
                filp->f_inode->i_ctime = date_dos2unix(psffsi->sfi_ctime, psffsi->sfi_cdate);
                filp->f_inode->i_dirt  = 1;
            }
            if (psffsi->sfi_tstamp & ST_PREAD) {
                filp->f_inode->i_atime = date_dos2unix(psffsi->sfi_atime, psffsi->sfi_adate);
                filp->f_inode->i_dirt  = 1;
            }
            if (psffsi->sfi_tstamp & ST_PWRITE) {
                filp->f_inode->i_mtime = date_dos2unix(psffsi->sfi_mtime, psffsi->sfi_mdate);
                filp->f_inode->i_dirt  = 1;
            }

            if ((rc = VFS_fsync(filp)) == NO_ERROR) {
                 psffsi->sfi_tstamp = 0;
            } else {
                kernel_printf("FS_COMMIT() - VFS_fsync returned %d", rc);
            }
        } else {
            kernel_printf("FS_COMMIT() - filp is NULL");
            rc = ERROR_INVALID_PARAMETER;
        }
    } else {
        rc =  ERROR_WRITE_PROTECT;
    }

    if (trace_FS_COMMIT) {
        kernel_printf("FS_COMMIT post-invocation : rc = %d", rc);
    }
    return rc;
}
