/* sig4.c (emx+gcc) */

/* This program tests if signals are delivered under DOS even if no
   system calls are performed. */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

static int sig_count = 0;

static void handler (int sig)
{
  printf ("Signal %d received\n", sig);
  if (++sig_count == 10)
    {
      printf ("10 signals received.\n");
      exit (0);
    }
  signal (sig, SIG_ACK);
}


int main (int argc, char *argv[])
{
  int infinite = 0;
  int i;

  i = 1;
  if (i < argc && strcmp (argv[i], "-i") == 0)
    {
      infinite = 1; ++i;
    }
  if (i != argc)
    {
      puts ("Usage: sig4 [-i]");
      return (1);
    }
  if (signal (SIGINT, handler) == SIG_ERR
      || signal (SIGBREAK, handler) == SIG_ERR)
    {
      puts ("signal failed");
      return (1);
    }
  while (infinite) ;
  for (i = 0; i < 20; ++i)
    sleep (1);
  return (0);
}
