/* sig3.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <setjmp.h>

static jmp_buf jump;

static void handler (int sig)
{
  printf ("Signal %d received\n", sig);
  signal (sig, SIG_ACK);
  longjmp (jump, 1);
}

int main (void)
{
  int c;

  if (signal (SIGINT, handler) == SIG_ERR)
    {
      puts ("signal failed");
      return (1);
    }
  if (setjmp (jump) != 0)
    puts ("jumped");
  for (;;)
    {
      c = fgetchar ();
      if (c == EOF)
        break;
      putchar (c);
    }
  putchar ('\n');
  return (0);
}
