/* sbrktest.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define FALSE 0
#define TRUE  1

extern void showmem (void);

int main (void)
{
  char buf[256], *p, *mem;
  int i, n, fill_flag, read_flag, write_flag, size;

  fill_flag = FALSE; read_flag = FALSE; write_flag = FALSE;
  mem = NULL;
  for (;;)
    {
      n = (int)sbrk (0);
      printf ("sbrk = 0x%x\n", n);
      n = (int)ulimit (3, 0);
      printf ("ulimit (3, 0) = 0x%x\n", n);
      printf ("? ");
      if (fgets (buf, sizeof (buf), stdin) == NULL)
        return (0);
      p = strchr (buf, '\n');
      if (p != NULL) *p = 0;
      switch (buf[0])
        {
        case 'q':
          return (0);
        case 'F':
          fill_flag = !fill_flag;
          printf ("Fill = %s\n", (fill_flag ? "on" : "off"));
          break;
        case 'R':
          read_flag = !read_flag;
          printf ("Read = %s\n", (read_flag ? "on" : "off"));
          break;
        case 'W':
          write_flag = !write_flag;
          printf ("Write = %s\n", (write_flag ? "on" : "off"));
          break;
        case 'r':
          printf ("read -> 0x%.2x\n", *mem);
          break;
        case 's':
          if (_osmode == OS2_MODE)
            showmem ();
          break;
        case 'w':
          *mem = 'X';
          break;
        case 'f':
          memset (mem, '*', size);
          break;
        case '=':
          i = (int)strtol (buf+1, NULL, 0);
          p = brk ((void *)i);
          if ((int)p == 0)
            printf ("ok.\n");
          else
            perror ("brk");
          break;
        case '0': case '1': case '2': case '3': case '4':
        case '5': case '6': case '7': case '8': case '9': case '-':
          size = (int)strtol (buf, NULL, 0);
          mem = sbrk (size);
          if ((int)mem == -1)
            perror ("sbrk");
          else
            {
              printf ("ok.\n");
              if (size > 0)
                {
                  if (read_flag)
                    printf ("read -> 0x%.2x\n", *mem);
                  if (write_flag)
                    *mem = 'X';
                  if (fill_flag)
                    memset (mem, '*', size);
                }
            }
          break;
        default:
          printf ("Pardon?\n");
          break;
        }
    }
}
