/* dlltest2.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>

extern int get_private (void);
extern void set_private (int x);
extern int get_shared (void);
extern void set_shared (int x);

static void show (void)
{
  printf ("shared=%d, private=%d\n", get_shared (), get_private ());
}

int main (int argc, char *argv[])
{
  int shared, private, i;

  if (argc != 3)
    {
      fputs ("Usage: dlltest2 <shared> <private>\n", stderr);
      return (1);
    }
  shared = atoi (argv[1]);
  private = atoi (argv[2]);

  show ();
  set_shared (shared);
  set_private (private);
  for (i = 0; i < 10; ++i)
    {
      show ();
      sleep (10);
    }
  return (0);
}
