/* nls.c (emx+gcc) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/nls.h>

#define BSZ 512

int main (int argc, char *argv[])
{
  unsigned char inp[BSZ], buf1[BSZ], buf2[BSZ], *p;
  int ext_flag;

  ext_flag = 0;
  if (argc == 2 && strcmp (argv[1], "-e") == 0)
    ext_flag = 1;
  _nls_init ();
  for (;;)
    {
      printf ("Input: ");
      if (fgets (inp, sizeof (inp), stdin) == NULL)
        break;
      p = strchr (inp, '\n');
      if (p != NULL) *p = 0;
      strcpy (buf1, inp);
      strcpy (buf2, inp);
      _nls_strupr (buf1);
      _nls_strlwr (buf2);
      printf ("Upper case: |%s|\n", buf1);
      printf ("Lower case: |%s|\n", buf2);
      if (ext_flag)
        {
          strcpy (buf1, inp);
          strcpy (buf2, inp);
          _remext (buf1);
          _defext (buf2, "ext");
          printf ("_remext: |%s|\n", buf1);
          printf ("_defext: |%s|\n", buf2);
          p = _getext (inp);
          if (p == NULL) p = "(NULL)";
          printf ("_getext: |%s|\n", p);
        }
    }
  return (0);
}
