/* sysconf.c (emx+gcc) -- Copyright (c) 1994 by Eberhard Mattes */

#include <unistd.h>
#include <limits.h>
#include <time.h>
#include <errno.h>

/* Return the POSIX.1  minimum values, for now. */

long sysconf (int name)
{
  switch (name)
    {
    case _SC_ARG_MAX:
      return (_POSIX_ARG_MAX);

    case _SC_CHILD_MAX:
      return (_POSIX_CHILD_MAX);

    case _SC_CLK_TCK:
      /* On emx, CLK_TCK is a constant.  On other systems, it may a
         macro which calls sysconf (_SC_CLK_TCK). */

      return (CLK_TCK);

    case _SC_NGROUPS_MAX:
      return (_POSIX_NGROUPS_MAX);

    case _SC_OPEN_MAX:
      return (_POSIX_OPEN_MAX);

    case _SC_STREAM_MAX:
      return (_POSIX_STREAM_MAX);

    case _SC_TZNAME_MAX:
      return (_POSIX_TZNAME_MAX);

    case _SC_JOB_CONTROL:
      return (-1);

    case _SC_SAVED_IDS:
      return (-1);

    case _SC_VERSION:
      return (_POSIX_VERSION);

    default:
      errno = EINVAL;
      return (-1);
    }
}
