/* splitpath.c (emx+gcc) -- Copyright (c) 1992-1993 by Eberhard Mattes */

#include <stdlib.h>
#include <string.h>

#define min(a,b) (((a) < (b)) ? (a) : (b))

void _splitpath (const char *src, char *drive, char *dir, char *fname,
                 char *ext)
{
  int i, j;

  i = 0;
  while (i < _MAX_DRIVE-2 && src[i] != 0 && src[i] != ':')
    ++i;
  if (i > 0 && src[i] == ':')
    {
      if (drive != NULL)
        _strncpy (drive, src, i+2);
      src += i+1;
    }
  else if (drive != NULL)
    *drive = 0;
  
  i = 0;
  for (j = 0; src[j] != 0; ++j)
    if (src[j] == '/' || src[j] == '\\')
      i = j + 1;
  if (dir != NULL)
    _strncpy (dir, src, min (_MAX_DIR, i + 1));
  src += i;
  
  i = 0;
  for (j = 0; src[j] != 0; ++j)
    if (src[j] == '.')
      i = j;
  if (i == 0)
    i = j;
  if (fname != NULL)
    _strncpy (fname, src, min (_MAX_FNAME, i + 1));
  src += i;
  
  if (ext != NULL)
    _strncpy (ext, src, _MAX_EXT);
}
