/* getgrnam.c (emx+gcc) -- Copyright (c) 1994 by Eberhard Mattes */

#include <string.h>
#include <sys/types.h>
#include <grp.h>

/* Dummy function */

struct group *getgrnam (const char *name)
{
  static struct group tmp_grp;
  static char *tmp_members;
  static char tmp_name[9];

  _strncpy (tmp_name, name, sizeof (tmp_name));
  tmp_members = NULL;
  tmp_grp.gr_name = tmp_name;
  tmp_grp.gr_gid = 0;
  tmp_grp.gr_mem = &tmp_members;
  return (&tmp_grp);
}
