/ math/libm.h (emx+gcc) -- Copyright (c) 1992-1994 by Eberhard Mattes

#define _LIBM_H
#include <errno.h>

#define _xam fxam; fstsww %ax; andb $0x45, %ah

#define j_nan cmpb $0x01, %ah; je
#define j_inf cmpb $0x05, %ah; je

#if defined (LONG_DOUBLE)
#define FLD fldt
#define FUN(X) __##X##l
#define DEF(X) __##X##l:
#define CONV(X)
#else
#define FLD fldl
#define FUN(X) _##X
#define DEF(X) _##X##:
#define CONV(X) fstpl X; fldl X
#endif

#if !defined (__MT__)

#define SETERRNO(x) \
        movl    x, _errno

#else

#define SETERRNO(x) \
        call    __errno_fun ;\
        movl    x, (%eax)

#endif
