/* tmpbuf.c (emx+gcc) -- Copyright (c) 1990-1993 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdio.h>

/* Assign the temporary buffer BUF of size BUFSIZ to STREAM. */

int _tmpbuf1 (FILE *stream, void *buf)
{
  stream->ptr = stream->buffer = (char *)buf;
  stream->wcount = BUFSIZ;
  stream->rcount = 0;
  stream->flags |= _IOWRT;
  stream->flags &= ~_IOBUFMASK;
  stream->flags |= _IOBUFTMP;
  return (0);
}

int _endbuf1 (FILE *stream)
{
  int result;

  result = fflush (stream);
  stream->buf_size = 1;
  stream->ptr = stream->buffer = &stream->char_buf;
  stream->flags &= ~_IOBUFMASK;
  stream->flags |= _IOBUFCHAR;
  stream->rcount = stream->wcount = 0;
  return (result);
}
