/* setvbuf.c (emx+gcc) -- Copyright (c) 1990-1994 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdio.h>
#include <stdlib.h>

int setvbuf (FILE *stream, char *buffer, int mode, size_t size)
{
  if (!(stream->flags & _IOOPEN)
      || (mode != _IONBF && mode != _IOFBF && mode != _IOLBF))
    return (EOF);

  fflush (stream);
  if ((stream->flags & _IOBUFMASK) == _IOBUFLIB)
    free (stream->buffer);
  stream->flags &= ~(_IOBUFMASK|_IOLBF|_IOFBF|_IONBF);

  if (mode == _IONBF)
    {
      stream->buf_size = 1;
      stream->buffer = &stream->char_buf;
      stream->flags |= _IONBF|_IOBUFCHAR;
    }
  else if (buffer != NULL && size >= 1 && size <= 0x400000)
    {
      /* ANSI X3.159-1989, 4.9.5.6: "If buf is not a null pointer, the
         array it points to may be used instead of a buffer allocated
         by the setvbuf function."

         We use that array unless SIZE is invalid. */

      stream->buf_size = size;
      stream->buffer = buffer;
      stream->flags |= mode|_IOBUFUSER;
    }
  else
    {
      /* ANSI X3.159-1989 doesn't assign any meaning to SIZE in this
         case.  We use SIZE as size of the buffer to allocate; if SIZE
         is invalid, use BUFSIZ instead. */

      if (size < 1 || size > 0x400000)
        size = BUFSIZ;
      buffer = malloc (size);
      if (buffer == NULL)
        return (EOF);
      stream->buf_size = size;
      stream->buffer = buffer;
      stream->flags |= mode|_IOBUFLIB;
    }
  stream->ptr = stream->buffer;
  stream->rcount = 0;
  stream->wcount = 0;
  return (0);
}
