/* access.c (emx+gcc) -- Copyright (c) 1990-1993 by Eberhard Mattes */

#include <sys/emx.h>
#include <string.h>
#include <io.h>
#include <errno.h>

int access (const char *name, int mode)
{
  int a, i, slash;
  char *tmp;

  /* If there is a trailing slash or backslash, remove it and set
     `slash' to TRUE.  Make a local copy of the string to remove the
     slash or backslash. */

  slash = FALSE;
  i = strlen (name);
  if (i > 1 && (name[i-1] == '\\' || name[i-1] == '/') &&
      (name[i-2] != '\\' && name[i-2] != '/' && name[i-2] != ':'))
    {
      slash = TRUE;
      tmp = alloca (i);
      memcpy (tmp, name, i);
      tmp[i-1] = 0;
      name = tmp;
    }

  /* Query the attributes of the file or directory. */

  a = __chmod (name, 0, 0);
  if (a < 0)
    return (-1);

  /* Fail if the name ends with a slash or backslash and is not a
     directory. */

  if (slash && !(a & _A_SUBDIR))
    {
      errno = ENOTDIR;
      return (-1);
    }

  /* Volume IDs are not accessible. */

  if (a & _A_VOLID)
    {
      errno = ENOENT;
      return (-1);
    }

  /* When testing for write permission, check the read-only bit. */

  if ((mode & 2) && (a & _A_RDONLY))
    {
      errno = EACCES;
      return (-1);
    }
  return (0);
}
