/* lldiv.c (emx+gcc) -- Copyright (c) 1992-1993 by Eberhard Mattes */

#include <stdlib.h>

_lldiv_t _lldiv (long long x, long long y)
{
  _ulldiv_t tmp;
  _lldiv_t r;

  if (x < 0)
    if (y < 0)
      {
        tmp = _ulldiv (-x, -y);
        r.quot = tmp.quot;
        r.rem = -tmp.rem;
      }
    else
      {
        tmp = _ulldiv (-x, y);
        r.quot = -tmp.quot;
        r.rem = -tmp.rem;
      }
  else
    if (y < 0)
      {
        tmp = _ulldiv (x, -y);
        r.quot = -tmp.quot;
        r.rem = tmp.rem;
      }
    else
      {
        tmp = _ulldiv (x, y);
        r.quot = tmp.quot;
        r.rem = tmp.rem;
      }
  return (r);
}
