/* dtsplit.c (emx+gcc) -- Copyright (c) 1987-1993 by Eberhard Mattes */

#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/param.h>
#include <sys/dirtree.h>


#define DELIM(c) ((c) == '/' || (c) == '\\')

int _dt_split (const char *src, char *dir, char *mask)
{
  unsigned char drive;
  char *p1, *p2;
  char old_dir[MAXPATHLEN+1];
  char path_buf[MAXPATHLEN+1];
  char mask_buf[MAXPATHLEN+1];
  int saved_errno;

  drive = _fngetdrive (src);
  if (drive != 0)
    {
      src += 2;
      if (*src == 0)
        src = ".";
    }
  else
    drive = _getdrive ();
  path_buf[0] = drive;
  path_buf[1] = ':';
  if (strlen (src) >= sizeof (path_buf) - 2)
    {
      errno = ENAMETOOLONG;
      return (-1);
    }
  strcpy (path_buf + 2, src);
  strcpy (mask_buf, "*.*");
  old_dir[0] = drive;
  old_dir[1] = ':';
  if (_getcwd1 (old_dir+2, drive) != 0)
    return (-1);
  saved_errno = errno;
  if (chdir (path_buf) != 0)
    {
      errno = saved_errno;
      p1 = NULL;
      for (p2 = path_buf+2; *p2 != 0; ++p2)
        if (DELIM (*p2))
          p1 = p2;
      if (p1 == NULL)
        {
          strcpy (mask_buf, path_buf+2);
          path_buf[2] = '.';
          path_buf[3] = 0;
        }
      else
        {
          if (p1[1] != 0)
            strcpy (mask_buf, p1+1);
          if (p1 == path_buf+2)
            path_buf[3] = 0;    /* root directory */
          else
            *p1 = 0;            /* remove last name */
        }
      if (chdir (path_buf) != 0)
        return (-1);
    }
  if (strcmp (mask_buf, "..") == 0)
    {
      chdir (old_dir);
      errno = EINVAL;
      return (-1);
    }
  if (_getcwd1 (path_buf+2, drive) != 0)
    {
      saved_errno = errno;
      chdir (old_dir);
      errno = saved_errno;
      return (-1);
    }
  if (path_buf[3] != 0)
    {
      p1 = strchr (path_buf, 0) - 1;
      if (DELIM (*p1))
        *p1 = 0;
    }
  chdir (old_dir);
  if (dir != NULL)
    strcpy (dir, path_buf);
  if (mask != NULL)
    strcpy (mask, mask_buf);
  return (0);
}
