/ tan.s (emx+gcc) -- Copyright (c) 1992-1993 by Steffen Haecker
/                    Modified 1993-1994 by Eberhard Mattes

#include <libm.h>

        .globl  FUN(tan)

        .text

        .align  2, 0x90

/ double tan (double x)
/
/ |x| >= 2^63 results in #NAN; errno is set to EDOM
/

#define x       4(%esp)

DEF(tan)
        FLD     x                       /* x */
        fptan

/* Note: fptan is followed by fstsww, avoiding a bug in the 486. */

        fstsww  %ax
        testb   $0x04, %ah
        jnz     1f                      /* C2 != 0 ? */

/* This used to be fdivrp.  However, on the 387, as opposed to the 8087,
   st(0) is always 1 after fptan. */

        fstp    %st(0)
        ret

1:      fldl    __const_NAN             /* #NAN */
        fstp    %st(1)
        fstp    %st(1)
        SETERRNO($EDOM)
        ret
