/* sys/ftruncat.c (emx+gcc) -- Copyright (c) 1992-1993 by Eberhard Mattes */

#include <sys/emx.h>
#include <os2emx.h>
#include "syscalls.h"

int __ftruncate (int handle, long length)
{
  ULONG rc;
  FILESTATUS3 info;

  rc = DosQueryFileInfo (handle, FIL_STANDARD, &info, sizeof (info));
  if (rc != 0)
    {
      _sys_set_errno (rc);
      return (-1);
    }
  if (info.cbFile > length)
    {
      rc = DosSetFileSize (handle, length);
      if (rc != 0)
        {
          _sys_set_errno (rc);
          return (-1);
        }
    }
  return (0);
}
