/* getwd.c (emx+gcc) -- Copyright (c) 1992-1993 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <sys/param.h>

char *getwd (char *buffer)
{
  char *p;

  if (buffer == NULL)
    {
      errno = EINVAL;
      return (NULL);
    }
  if (__getcwd (buffer+1, 0) < 0)
    {
      _strncpy (buffer, strerror (errno), MAXPATHLEN);
      return (NULL);
    }
  for (p = buffer+1; *p != 0; ++p)
    if (*p == '\\') *p = '/';
  buffer[0] = '/';
  return (buffer);
}
