/* wmmove.c (emx+gcc) -- Copyright (c) 1987-1993 by Eberhard Mattes */

#include <sys/winmgr.h>
#include "winmgr2.h"

void wm_move (wm_handle wh, int new_x, int new_y)
{
  int i, dx, dy;
  wm_handle p;
  struct _wm_window new_win, old_win;

  if (wh->used != WM_USED)
    return;
  dx = new_x - wh->x0;
  dy = new_y - wh->y0;
  old_win = new_win = *wh;
  new_win.x0 += dx; new_win.x1 += dx; new_win.bx0 += dx; new_win.bx1 += dx;
  new_win.y0 += dy; new_win.y1 += dy; new_win.by0 += dy; new_win.by1 += dy;
  if (new_win.open)
    {
      _wm_unhide1 (wh, &new_win);                         /* Show background */
      *wh = new_win;
      _wm_copy1 (wh, &old_win);                           /* Save background */
      _wm_hide1 ();                                    /* Hide lower windows */
      for (i = 0; i < _wm_count; ++i)
        {
          p = _wm_idx[i];
          if (p == wh)
            break;
          if (p->open && _wm_jam1 (p, &old_win))
            _wm_put1 (p);
        }
      _wm_put1 (wh);                              /* Restore window contents */
    }
  else
    *wh = new_win;
  _wm_cursor1 ();
}
