/* vfopen.c (emx+gcc) -- Copyright (c) 1993-1994 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdio.h>
#include <stdarg.h>
#include <sys/video.h>
#include "video2.h"

static int _vflush (FILE *stream, int c)
{
  int n;

  if (c == _FLUSH_FILL)
    return (-1);
  n = stream->ptr - stream->buffer;
  if (n > 0)
    {
      if (c >= 0 && n < stream->buf_size)
        {
          *stream->ptr = (char)c;
          ++n;
          c = -1;               /* Don't write character separately */
        }
      _v_puts_len (stream->buffer, n);
    }
  stream->ptr = stream->buffer;
  stream->wcount = stream->buf_size;
  if (c >= 0)
    {
      if (stream->buf_size == 0)
        v_putc (c);
      else
        {
          *stream->ptr++ = (char)c;
          --stream->wcount;
        }
    }
  return (0);
}


FILE *v_fopen (void)
{
  FILE *stream;

  stream = _newstream ();
  if (stream == NULL)
    return (NULL);
  stream->buffer = NULL;
  stream->ptr = NULL;
  stream->rcount = 0;
  stream->wcount = 0;
  stream->handle = -1;
  stream->flags = _IOOPEN|_IOSPECIAL|_IOBUFNONE|_IOWRT|_IONBF;
  stream->buf_size = 0;
  stream->flush = _vflush;
  stream->tmpidx = 0;
  return (stream);
}


int v_fclose (FILE *stream)
{
  int result;

  if ((stream->flags & (_IOOPEN|_IOSPECIAL)) != (_IOOPEN|_IOSPECIAL)
      || stream->flush != _vflush)
    return (-1);
  result = fflush (stream);
  stream->flags = 0;
  return (result);
}
