/* gettimeo.c (emx+gcc) -- Copyright (c) 1993 by Eberhard Mattes */

#include <sys/emx.h>
#include <sys/timeb.h>
#include <time.h>
#include <sys/time.h>

int gettimeofday (struct timeval *tp, struct timezone *tzp)
{
  struct timeb tb;

  if (!_tzset_flag) tzset ();
  __ftime (&tb);
  if (tp != NULL)
    {
      tp->tv_sec = tb.time + timezone;
      tp->tv_usec = tb.millitm * 1000;
    }
  if (tzp != NULL)
    {
      tzp->tz_minuteswest = timezone / 60;
      tzp->tz_dsttime = 0; /* daylight && _dst (&tm); */
    }
  return (0);
}
