/* sys/execname.c (emx+gcc) -- Copyright (c) 1993 by Eberhard Mattes */

#include <sys/emx.h>
#define INCL_DOS
#include <os2emx.h>
#include <string.h>
#include "syscalls.h"

int __execname (char *dst, size_t size)
{
  ULONG rc;
  PTIB ptib;
  PPIB ppib;

  if (size == 0)
    return (-1);

  rc = DosGetInfoBlocks (&ptib, &ppib);
  if (rc != 0)
    {
      *dst = 0;
      return (-1);
    }

  rc = DosQueryModuleName (ppib->pib_hmte, size, dst);
  if (rc != 0)
    {
      *dst = 0;
      return (-1);
    }
  return (0);
}
