/* ghostbyn.c (emx+gcc) -- Copyright (c) 1994 by Eberhard Mattes */

#include <sys/emx.h>
#include <sys/types.h>
#include <netdb.h>
#include <errno.h>

extern int h_errno;

struct hostent *gethostbyname (const char *name)
{
  struct hostent *result;
  int saved_errno;

  saved_errno = errno;
  if (__gethostbyname (name, &result) != 0)
    {
      if (errno > 4)            /* ENOSYS! */
        h_errno = NO_RECOVERY;
      else
        h_errno = errno;
      result = NULL;
    }
  errno = saved_errno;
  return (result);
}
