/* mbstowcs.c (emx+gcc) -- Copyright (c) 1994 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdlib.h>
#include <limits.h>


size_t mbstowcs (wchar_t *pwcs, const char *s, size_t n)
{
  int shift, i;
  size_t result;

  shift = 0; result = 0;
  switch (_cur_mbyte.mode)
    {
    case _MB_8BITS:
      while (*s != 0 && n != 0)
        {
          pwcs[result++] = (unsigned char)*s++;
          --n;
        }
      break;

    default:
      while (*s != 0 && n != 0)
        {
          i = _mbtowc (pwcs + result, s, MB_LEN_MAX, &shift);
          if (i < 1)
            return ((size_t)-1);
          s += i; ++result; --n;
        }
      break;
    }

  if (n != 0)
    pwcs[result] = 0;
  return (result);
}
