/* impsockh.c (emx+gcc) */

/* Test _impsockhandle(). */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>

int main (int argc, char *argv[])
{
  int s, fd;
  char msg[] = "pirated socket!";

  if (argc != 2 || (s = atoi (argv[1])) == 0)
    {
      fputs ("Usage: impsockh <socket_handle>\n", stderr);
      exit (2);
    }
  fd = _impsockhandle (s, 0);
  if (fd == -1)
    {
      perror ("_impsockhandle()");
      exit (2);
    }

  /* Give a chance to interrupt or pause for testing and checking
     reference counts. */

  printf ("Sleeping...");
  sleep (2);
  printf ("Writing to socket\n");
  if (write (fd, msg, sizeof (msg) - 1) == -1)
    {
      perror ("write()");
      exit (2);
    }
  if (close (fd) != 0)
    {
      perror ("close()");
      exit (2);
    }
  return (0);
}
