/* sprintf.c (emx+gcc) -- Copyright (c) 1990-1995 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdio.h>
#include <stdarg.h>
#include <limits.h>

int sprintf (char *buffer, const char *format, ...)
{
  va_list arg_ptr;
  FILE trick;
  int result;

  va_start (arg_ptr, format);
  trick.buffer = buffer;
  trick.ptr = buffer;
  trick.rcount = 0;
  trick.wcount = INT_MAX;
  trick.handle = -1;
  trick.flags = _IOOPEN|_IOSPECIAL|_IOBUFUSER|_IOWRT;
  trick.buf_size = INT_MAX;
  trick.flush = NULL;
  trick._ungetc_count = 0;
  result = _output (&trick, format, arg_ptr);
  putc (0, &trick);
  va_end (arg_ptr);
  return (result);
}
