/* fill.c (emx+gcc) -- Copyright (c) 1990-1995 by Eberhard Mattes */

#include <sys/emx.h>
#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <errno.h>

/* Note: _fill() now (as of emx 0.9a fix04) assumes that `rcount' has
   been decremented prior to calling _fill().  See ungetc.c for
   details. */

int _fill (FILE *stream)
{
  /* Undo decrementing of `rcount'.  This wasn't required in earlier
     versions as `rcount' was set but not examined by _fill().
     Moreover, this fixes the bug of `rcount' being wrong if _fill()
     fails. */

  ++stream->rcount;

  /* Fail if the stream is not open. */

  if (!(stream->flags & _IOOPEN))
    {
      errno = EACCES;
      return (EOF);
    }

  /* Fail if the stream is in write mode. */

  if (stream->flags & _IOWRT)
    {
      stream->flags |= _IOERR;
      errno = EACCES;
      return (EOF);
    }

  if (stream->_ungetc_count != 0)
    {
      int c;

      /* There are pushed-back characters.  Return the most recent one
         and undo the effects of one ungetc() call. */

      stream->_ungetc_count -= 1;
      c = (unsigned char)stream->buffer[stream->_ungetc_count];

      if (stream->_ungetc_count == 0)
        stream->rcount = -stream->rcount;

      return (c);
    }

  if (stream->flags & _IOSPECIAL)
    {
      if (stream->flush != NULL)
        return (stream->flush (stream, _FLUSH_FILL));
      errno = EACCES;
      return (EOF);
    }

  /* Switch to read mode. */

  stream->flags |= _IOREAD;
  stream->wcount = 0;
  if (nbuf (stream))
    _fbuf (stream);
  else
    stream->ptr = stream->buffer;

  /* Fill the buffer. */

  stream->flags &= ~_IOUNGETC;
  stream->rcount = read (fileno (stream), stream->buffer, stream->buf_size);
  if (stream->rcount < 0)
    {
      stream->flags |= _IOERR;
      stream->rcount = 0;
      return (EOF);
    }

  /* Check for EOF. */

  if (stream->rcount == 0)
    {
      stream->flags |= _IOEOF;
      return (EOF);
    }

  /* Return the next character. */

  --stream->rcount;
  return ((unsigned char)*stream->ptr++);
}
