/* texi2dvi.cmd -- Make .dvi file from texinfo file
   Copyright (c) 1993-1995 Eberhard Mattes

This file is part of emx.

emx is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

emx is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emx; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */


'@echo off'

/* Change the next line to have_diff = 1 if you have GNU diff */

have_diff = 0
tex_prog = 'tex386'

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

debug = 0
force = 0

parse arg arg1 rest
do while (length( arg1) >= 2) & (substr( arg1, 1, 1) = '-')
  if arg1 = '-h' then
    call Usage
  else if arg1 = '-d' then
    debug = 1
  else if arg1 = '-f' then
    force = 1
  else
  do
    say arg1 'is not a valid option'
    exit 1
  end
  options = options arg1
  parse var rest arg1 rest
end
if arg1 = '' then
do
  say 'Missing file name; use -h for help'
  exit 1
end
if rest \= '' then
do
  say 'Too many command line arguments:' rest
  exit 1
end

inputfile = arg1
if debug then say 'Input file:' inputfile
if \ exists( inputfile) then
do
  say inputfile 'does not exist'
  exit 1
end

parse var inputfile basename '.' ext
if debug then say inputfile 'time:' gettime( inputfile)

dvifile = basename'.dvi'
if (\ force) & exists( dvifile) then
do
  if debug then say dvifile 'time:' gettime( dvifile)
  if newer( dvifile, inputfile) then
  do
    say dvifile 'is up-to-date'
    exit 0
  end
end

call get_index_files 'orig_index_files'
delete_files = ''
do i = 1 to words( orig_index_files)
  src = word( orig_index_files, i)
  parse var src indexbase '.' ext
  dst = 'texi2dvi.'ext
  if debug then say 'Copying' src 'to' dst
  'copy' src dst '>nul'
  delete_files = delete_files dst
end

changed = 0
if run_texindex_and_tex( 'orig_index_files_sans_aux') then
do
  call get_index_files 'new_index_files'
  if orig_index_files \= new_index_files then
    changed = 1
  else
  do i = 1 to words( orig_index_files) until changed
    src = word( orig_index_files, i)
    dst = word( delete_files, i)
    if debug then say 'Comparing ' src 'to' dst
    changed = \ compare( src, dst)
  end
end

if length( delete_files) > 0 then
do
  if debug then say 'Deleting' delete_files
  'del' delete_files
end

if changed then
  call run_texindex_and_tex 'new_index_files_sans_aux'

exit 0

Usage: procedure
  say 'Usage: texi2dvi [-d] [-f] [-h] filename'
  say ''
  say '-d   turn on debugging output'
  say '-f   force; run TeX even if DVI file is newer than input file'
  say '-h   display this message'
  exit 1

exists: procedure
arg fname
  return stream( fname, 'C', 'QUERY EXISTS') \= ''

newer: procedure
arg fname1, fname2
return gettime( fname1) > gettime( fname2)

gettime: procedure
arg fname
  datetime = stream( fname, 'C', 'QUERY DATETIME')
  parse var datetime month'-'day'-'year hour':'min':'sec
  if year < 50 then year = year + 2000
  else year = year + 1900
  return year||month||day||hour||min||sec

get_index_files:
arg files
  call value files, ''
  call SysFileTree basename'.??', filelist, 'F'
  do i = 1 to filelist.0
    if debug then say filelist.i
    fname = filespec( 'name', substr( filelist.i, 38))
    parse var fname indexbase '.' ext
    if length( ext) = 2 then
      call checkindex fname, files
  end
  call value files'_sans_aux', value( files)
  call checkindex basename'.aux', files
  if debug then say value( files)
  return

checkindex:
arg fname, files
  line = linein( fname)
  call stream fname, 'C', 'CLOSE'
  if length( line) > 0 then
  do
    firstchar = substr( line, 1, 1)
    if (firstchar = '\') | (firstchar = "'") then
    do
      if debug then say fname 'is an index file'
      call value files, value( files) fname
    end
  end
  return

compare: procedure expose have_diff
arg fname1, fname2
  if have_diff then
    return compare_diff( fname1, fname2)
  else
    return compare_rexx( fname1, fname2)

compare_diff: procedure
arg fname1, fname2
  'diff -q' fname1 fname2
  return RC = 0

compare_rexx: procedure
arg fname1, fname2
  different = 0
  identical = 0
  do until different | identical
    ok1 = lines( fname1)
    ok2 = lines( fname2)
    if ok1 \= ok2 then
      different = 1
    else if \ ok1 then
      identical = 1
    else
    do
      line1 = linein( fname1)
      line2 = linein( fname2)
      if line1 \= line2 then
        different = 1
    end
  end
  call stream fname1, 'C', 'CLOSE'
  call stream fname2, 'C', 'CLOSE'
  return identical

run_texindex_and_tex:
arg files
  if words( value( files)) > 0 then
  do
    if debug then say 'Running texindex' value( files)
    'texindex' value( files)
  end
  tex_prog inputfile
  return RC < 2
