/* malloc.h (emx+gcc) */

#if !defined (_MALLOC_H)
#define _MALLOC_H

#if defined (__cplusplus)
extern "C" {
#endif

#if !defined (_SIZE_T)
#define _SIZE_T
typedef unsigned long size_t;
#endif

#if !defined (NULL)
#define NULL ((void *)0)
#endif

#if !defined (_POSIX_SOURCE) && !defined (_HEAPOK)
#define _HEAPOK       0
#define _HEAPEMPTY    1
#define _HEAPBADBEGIN 2
#define _HEAPBADNODE  3
#define _HEAPBADEND   4
#define _HEAPBADROVER 5
#endif

void *calloc (size_t elements, size_t size);
void free (void *mem);
void *malloc (size_t size);
void *realloc (void *mem, size_t size);

#if !defined (_POSIX_SOURCE)

void *_tcalloc (size_t elements, size_t size);
void _tfree (void *mem);
void *_tmalloc (size_t size);
void *_trealloc (void *mem, size_t size);

void *_expand (void *mem, size_t new_size);
int _heapchk (void);
int _heapset (unsigned fill);
size_t _msize (__const__ void *mem);

#endif

#if defined (__cplusplus)
}
#endif

#endif /* !defined (_MALLOC_H) */
