/* sys/signal.h (emx+gcc) */

#if !defined (_SYS_SIGNAL_H)
#define _SYS_SIGNAL_H

#if defined (__cplusplus)
extern "C" {
#endif

typedef int sig_atomic_t;

#if !defined (_SIGSET_T)
#define _SIGSET_T
typedef unsigned long sigset_t;
#endif

struct sigaction
{
  void (*sa_handler)(int _sig);
  sigset_t sa_mask;
  int sa_flags;
};

#if !defined (_POSIX_SOURCE)

#define SIGTY void

#endif

#define SIGHUP    1 /* Hangup */
#define SIGINT    2 /* Interrupt (Ctrl-C) */
#define SIGQUIT   3 /* Quit */
#define SIGILL    4 /* Illegal instruction */
#define SIGTRAP   5 /* Single step (debugging) */
#define SIGABRT   6 /* abort () */
#define SIGEMT    7 /* EMT instruction */
#define SIGFPE    8 /* Floating point */
#define SIGKILL   9 /* Kill process */
#define SIGBUS   10 /* Bus error */
#define SIGSEGV  11 /* Segmentation fault */
#define SIGSYS   12 /* Invalid argument to system call */
#define SIGPIPE  13 /* Broken pipe */
#define SIGALRM  14 /* Alarm */
#define SIGTERM  15 /* Termination, process killed */
#define SIGUSR1  16 /* User-defined signal #1 */
#define SIGUSR2  17 /* User-defined signal #2 */
#define SIGCHLD  18 /* Death of a child process */
#define SIGBREAK 21 /* Break (Ctrl-Break) */

#define SIGCLD   SIGCHLD

#define NSIG 22

#define SIG_DFL ((void (*)(int))0)
#define SIG_IGN ((void (*)(int))1)

#if !defined (_POSIX_SOURCE)

#define SIG_ACK ((void (*)(int))4)

#endif

#define SIG_ERR ((void (*)(int))-1)

#define SA_NOCLDSTOP    0x0001

#if !defined (_POSIX_SOURCE)

#define SA_SYSV         0x0002  /* Reset to SIG_DFL */
#define SA_ACK          0x0004  /* Don't unblock automatically */

#endif

#define SIG_BLOCK       1
#define SIG_UNBLOCK     2
#define SIG_SETMASK     3


int kill (int _pid, int _sig);
int pause (void);
int raise (int _sig);
void (*signal (int _sig, void (*handler)(int _sig)))(int _sig);

int sigaction (int _sig, __const__ struct sigaction *_iact,
    struct sigaction *_oact);
int sigpending (sigset_t *_set);
int sigprocmask (int _how, __const__ sigset_t *_iset, sigset_t *_oset);
int sigsuspend (__const__ sigset_t *_mask);

int sigaddset (sigset_t *_set, int _sig);
int sigdelset (sigset_t *_set, int _sig);
int sigemptyset (sigset_t *_set);
int sigfillset (sigset_t *_set);
int sigismember (__const__ sigset_t *_set, int _sig);

#define _SIGMASK(sig) ((sigset_t)1 << ((sig) - 1))
#define __sigaddset(set,sig)   (*(set) |= _SIGMASK (sig), 0)
#define __sigdelset(set,sig)   (*(set) &= ~_SIGMASK (sig), 0)
#define __sigemptyset(set)     (*(set) = 0, 0)
#define __sigfillset(set)      (*(set) = ~(sigset_t)0, 0)
#define __sigismember(set,sig) ((*(set) & _SIGMASK (sig)) ? 1 : 0)


#if defined (__cplusplus)
}
#endif

#endif /* !defined (_SYS_SIGNAL_H) */
