/*
FONTED52.CPP done by Joonas Pihlajamaa alias Jokke.
Re-compiling this means that you have agreed statements
of README.DOC. Modified version can be used only with
own computer, distributing modified version is illegal !
*/
#include "animate.h"
#include "font.h"
#define MOUSE 0x33

void mouse(int a) { _AX=a; geninterrupt(MOUSE); }
void initcursor();
void initgraphics();
void checkmenu();
void drawpoint();
void putfont();
void putpoint(int bx, int by, int color);
void savefonts(char *);
void loadfonts(char *);

animation cursor;
font standard("cube.fnt");
BYTE pois=FALSE, button;
char curfont=1;
WORD x, y, oldx, oldy, timeup=0;
char far *fontptr=(char far *)farmalloc(8*5*256);

int main(int argc, char *argv[]) {
	mouse(0);
	if(_AX != FALSE) {
		initgraphics();
		initcursor();
		if(argc > 1) loadfonts(argv[1]);
		else loadfonts("cube.fnt");
		putfont();
		_CX=0;
		_DX=630;
		mouse(7);
		while(!pois) {
			cursor.hide();
			_AX=3; geninterrupt(MOUSE);
			button=_BX; x=_CX/2; y=_DX;
			cursor.setloc(x, y);
			cursor.show();
			cursor.onscreen();
			checkmenu();
			if(!timeup) drawpoint();
			else timeup--;
			while(kbhit()) {
				cursor.hide();
				curfont=getch();
				putfont();
				cursor.show();
			}
		}
		if(argc > 1) savefonts(argv[1]);
		else savefonts("cube.fnt");
		textmode(0x03);
	} else cprintf("\r\nMouse driver not installed.\n\r");
	return(0);
}

void initcursor() {
	cursor.loadobj("cursor.jp");
	cursor.allocback( cursor.getxsize(), cursor.getysize() );
	cursor.link(0);
	cursor.show();
}

void initgraphics() {
	textmode(0x13);
	if( dblbuf != NULL && fontptr != NULL) {
		_fmemcpy( dblbuf, screen, 64000);
		_fmemcpy( fontptr, screen, 256*40);
	} else
		exit(1);
	for(x=0; x<320*9; x++)
		dblbuf[x] = 150;
	dblbuf[320*4+2] = 0;
	for(y=0; y<1600; y+=320)
		dblbuf[y+4]=0;
	for(y=320*9; y<320*51; y+=320) {
		dblbuf[y+4]=150;
		dblbuf[y+30]=150;
	} for(x=5; x<30; x++) {
		dblbuf[320*9+x]=150;
		dblbuf[320*50+x]=150;
	}
	standard.gprint("FontEdit version 5.2",60,0,50);
}

void checkmenu() {
	if(x<5 && y<5 && button) pois = TRUE;
}

void drawpoint() {
	WORD bx=x/5*5, by=y/5*5;
	BYTE color;
	if(button==TRUE && x<30 && x>4 && y<50 && y>9) {
		cursor.hide();
		if(fontptr[256*5* ((y-10)/5) +curfont*5+((x-5)/5)]==1) {
			fontptr[256*5* ((y-10)/5) +curfont*5+((x-5)/5)]=color=0;
		} else {
			fontptr[256*5* ((y-10)/5) +curfont*5+((x-5)/5)]=color=1;
		}
		for(; bx<x/5*5+5; bx++)
			for(by=y/5*5; by<y/5*5+5; by++)
				dblbuf[by*320+bx]=color*100;
		cursor.show();
		timeup=50;
	}
}

void putfont() {
	int bx, by;
	for(bx=0; bx<5; bx++)
		for(by=0; by<8; by++) {
			if(fontptr[256*5*by +  curfont*5+bx ]==1)
				putpoint(bx*5+5, by*5+10, 100);
			else
				putpoint(bx*5+5, by*5+10, 0);
		}
}

void putpoint(int bx, int by, int color) {
	int cx=bx, cy=by;
	for(; bx<cx+5; bx++)
		for(by=cy; by<cy+5; by++)
			dblbuf[by*320 +bx]=color;
}

void savefonts(char *tiednimi) {
	FILE *handle;
	WORD pointer;

	handle=fopen(tiednimi, "wb");
	for(pointer=0; pointer<256*40; pointer++)
		fputc(fontptr[pointer], handle);
	fcloseall();
}

void loadfonts(char *tiednimi) {
	FILE *handle;
	WORD pointer;

	handle=fopen(tiednimi, "rb");
	for(pointer=0; pointer<256*40; pointer++)
		fontptr[pointer]=fgetc(handle);
	fcloseall();
}