void loadpcx(char *);
void loadptr(char *, char far *pointer, char doalloc);
void loadpal(char *);
void shadetoblack(char *, unsigned int waittime);
void shadefromblack(char *, unsigned int waittime);
void showscreen_up(int lenght);
void showscreen_down(int lenght);
void hidescreen_down(int lenght);
void hidescreen_up(int lenght);

void loadpcx(char *tiednimi) {
  FILE *handle=fopen(tiednimi,"rb");
  unsigned short tavu,tavu2, c, maxx, maxy;

  if(handle==NULL) exit(1);
  fseek(handle,8,SEEK_SET);
  maxy=fgetc(handle) + (fgetc(handle) << 8) +1;
  maxx=fgetc(handle) + (fgetc(handle) << 8) +1;
  fseek(handle,128,SEEK_SET);
  for(c=0; c<maxy*maxx;) {
    tavu=fgetc(handle);
    if(tavu>192) {
      tavu2=fgetc(handle);
      for(;tavu>192;tavu--)
	dblbuf[c++]=tavu2;
    } else dblbuf[c++]=tavu;
  }
  fclose(handle);
}
void loadptr(char *tiednimi, char far *pointer, char doalloc) {
  FILE *handle=fopen(tiednimi,"rb");
  unsigned short tavu,tavu2, c, maxx, maxy;

  if(handle==NULL) exit(1);
  fseek(handle,8,SEEK_SET);
  maxy=fgetc(handle) + (fgetc(handle) << 8) +1;
  maxx=fgetc(handle) + (fgetc(handle) << 8) +1;
  if(doalloc) {
      pointer = (char far *)farmalloc(maxx * maxy);
      if(pointer == NULL) exit(1);
  }
  fseek(handle,128,SEEK_SET);
  for(c=0; c<maxy*maxx;) {
    tavu=fgetc(handle);
    if(tavu>192) {
      tavu2=fgetc(handle);
      for(;tavu>192;tavu--)
	pointer[c++]=tavu2;
    } else pointer[c++]=tavu;
  }
  fclose(handle);
}
void loadpal(char *tiednimi) {
  FILE *handle=fopen(tiednimi,"rb");
  char paletti[768];
  int c;

  if(handle==NULL) exit(1);
  fseek(handle,-768,SEEK_END);
  for(c=0; c<256; c++) {
    paletti[c*3+0] =fgetc(handle)/4;
    paletti[c*3+1] =fgetc(handle)/4;
    paletti[c*3+2] =fgetc(handle)/4;
  }
  outportb(0x3C8,0);
  for(c=0; c<256*3; c++)
    outportb(0x03C9,paletti[c]);
  fclose(handle);
}
void shadetoblack(char *tiednimi, unsigned int waittime) {
  FILE *handle=fopen(tiednimi,"rb");
  char paletti[768];
  int n,c, i;

  if(handle==NULL) exit(1);
  fseek(handle,-768,SEEK_END);
  for(c=0; c<256; c++) {
    paletti[c*3+0] =fgetc(handle)/4;
    paletti[c*3+1] =fgetc(handle)/4;
    paletti[c*3+2] =fgetc(handle)/4;
  }
  for(n=0; n<64; n++) {
      for(i=0; i<768; i++)
	  if(paletti[i]) paletti[i]-=1;
      outportb(0x3C8,0);
      for(c=0; c<256*3; c++)
	  outportb(0x03C9,paletti[c]);
      delay(waittime);
  }
  fclose(handle);
}
void shadefromblack(char *tiednimi, unsigned int waittime) {
  FILE *handle=fopen(tiednimi,"rb");
  char paletti[768];
  char apupaletti[768];
  int n,c, i;

  if(handle==NULL) exit(1);
  fseek(handle,-768,SEEK_END);
  for(c=0; c<256; c++) {
    paletti[c*3+0] =fgetc(handle)/4;
    paletti[c*3+1] =fgetc(handle)/4;
    paletti[c*3+2] =fgetc(handle)/4;
  }
  for(c=0; c<768; c++)
      apupaletti[c]=0;
  for(n=0; n<64; n++) {
      for(i=0; i<768; i++)
	  if(apupaletti[i] < paletti[i]) apupaletti[i]+=1;
      outportb(0x3C8,0);
      for(c=0; c<256*3; c++)
	  outportb(0x03C9,apupaletti[c]);
      delay(waittime);
  }
  fclose(handle);
}
void showscreen_up(int lenght) {
    unsigned int x, y=0;
    char far *temp;
	temp=dblbuf;
	dblbuf=dblbuf+64000;
	for(x=0; x<320*lenght; x+=320) {
	    dblbuf-=320;
	    y+=320/4;
	    asm {
		push ds
		les  di,[screen]
		lds  si,[dblbuf]
		mov  cx, y
		db   0x66
		rep  movsw
		pop  ds
	    }
	}
    dblbuf=temp;
}
void showscreen_down(int lenght) {
    unsigned int x, y=0;
    char far *temp;
	temp=dblbuf;
	screen+=64000;
	for(x=0; x<320*lenght; x+=320) {
	    y+=320/4;
	    screen-=320;
	    asm {
		push ds
		les  di,[screen]
		lds  si,[dblbuf]
		mov  cx, y
		db   0x66
		rep  movsw
		pop  ds
	    }
	}
    dblbuf=temp;
    screen=(char far *)0xA0000000;
}
void hidescreen_down(int lenght) {
    unsigned int x, y;
    char far *empty=(char far *)farmalloc(320);
    if(empty != NULL) {
	for(x=0; x<320; x++) empty[x]=0;
	for(x=0; x<320*lenght; x+=320) {
	    asm {
		push ds
		les  di,[screen]
		lds  si,[empty]
		mov  cx, 320 / 4
		db   0x66
		rep  movsw
		pop  ds
	    }
	    y=(64000-x) / 4;
	    screen+=320;
	    asm {
		push ds
		les  di,[screen]
		lds  si,[dblbuf]
		mov  cx, y
		db   0x66
		rep  movsw
		pop  ds
	    }
	}
    }
    screen=(char far *)0xA0000000;
    farfree(empty);
}
void hidescreen_up(int lenght) {
    unsigned int x, y;
    char far *empty=(char far *)farmalloc(320);
    char far *temp;
    char far *tempscreen=(char far *)0xA0000000+64000;
    if(empty != NULL) {
	temp=dblbuf;
	for(x=0; x<320; x++) empty[x]=0;
	for(x=0; x<320*lenght; x+=320) {
	    y=(64000-x-320) / 4;
	    dblbuf+=320;
	    asm {
		push ds
		les  di,[screen]
		lds  si,[dblbuf]
		mov  cx, y
		db   0x66
		rep  movsw
		pop  ds
	    }
	    tempscreen-=320;
	    asm {
		push ds
		les  di,[tempscreen]
		lds  si,[empty]
		mov  cx, 320 / 4
		db   0x66
		rep  movsw
		pop  ds
	    }
	}
    }
    dblbuf=temp;
    farfree(empty);
}