//	TOOLS.C
//	Patrick Tennberg, 1994,95,96

#define	STRICT
#include	"includes.h"
#pragma	hdrstop
#include	"tools.h"

LPCSTR ResString(HWND hWnd,UINT wID,LPSTR szStr,int cchBuffer)
  {
	HINSTANCE hInstance = (HINSTANCE) GetWindowLong(hWnd,GWL_HINSTANCE);

	LoadString(hInstance,wID,szStr,cchBuffer);

	return szStr;
  }

void Copy(char *s, int start, int len, char *sRet)
  {
	int lenSrc = lstrlen(s);

  if ((0 == len) || (start >= lenSrc))
    {
	  sRet[0] = '\0';
	  return;
    };

  if (start + len > lenSrc)
	 len = lenSrc - start;

	memcpy(sRet,s + start,len);

  sRet[len] = '\0';
  }

//	Return just the drive:directory portion of a pathName
void JustPathName(char *pathName, char *sRet)
  {
  int 	i;
  char 	t[MAXPATH];

  for (i = lstrlen(pathName) - 1;(pathName[i] != '\\') && (pathName[i] != ':') && (i != -1);i--);
  if (-1 == i)
    {
	 // no drive or directory name
	 sRet[0] = '\0';
	 return;
    }
  lstrcpy(t, pathName);
  if (0 == i)
    {
	  // either the root directory of default drive or invalid pathName
	  Copy(t, 0, 1, sRet);
	  sRet[1] = '\0';
	  return;
    }
  if ('\\' == t[i])
    {
	  if (':' == pathName[i-1])
	    {
		  // root directory of a drive, leave the trailing backslash
		  Copy(t, 0, i+1, sRet);
	    }
	  else
	    {
		  // subdirectory, remove the trailing backslash
		  Copy(t,0,i,sRet);
	    }
    }
  else
    {
	  // either the default directory of a drive or invalid pathName
	  Copy(t,0,i+1,sRet);
    }
  }

char *AddBackslash(char *fname)
  {
	int len = lstrlen(fname);

	if (len > 1 && fname[len - 1] != '\\')
		strcat(fname,"\\");

	return fname;
  }

LPSTR ModulePath(LPSTR returnPath)
  {
	char fullPath[MAXPATH];

	GetModuleFileName(NULL,fullPath,MAXPATH);
	JustPathName(fullPath,returnPath);
	AddBackslash(returnPath);

	return returnPath;
  }

void CenterWindow(HWND hWnd,BOOL fAlwaysOnTop)
  {
	RECT 	rc,rcParent;
	int		newX,newY,centerX,centerY;

	//	Center dialog box
	GetWindowRect(GetDesktopWindow(),&rcParent);
	GetWindowRect(hWnd,&rc);
	centerX = (rcParent.left + rcParent.right) / 2;
	centerY = (rcParent.top + rcParent.bottom) / 2;

	newX = centerX - ((rc.right - rc.left) / 2);
	newY = centerY - ((rc.bottom - rc.top) / 2);

	if (TRUE == fAlwaysOnTop)
		SetWindowPos(hWnd,HWND_TOPMOST,newX,newY,0,0,SWP_NOSIZE);
	else
		SetWindowPos(hWnd,NULL,newX,newY,0,0,SWP_NOSIZE);
  }

