//	REGDATA.C
//	Patrick Tennberg, 1994,95,96

#define	STRICT
#include	"includes.h"
#pragma	hdrstop
#include	"regdata.h"

//	Local variables for the module
static LPSTR szSubKeyName	= "Software\\Calvin";
static LPSTR szKeyClass		= "Calvin";
static LPSTR szSubKeys[] = 
  {
	"Calvin_DisplayTime",	  //	RT_DISPLAYTIME
	"Calvin_AlwaysOnTop"		//	RT_ALWAYSONTOP
  };

//	Retrive data stored in the windows registry
int RetriveData(enum ERegTypes rtType,int nDefaultData)
  {
	LONG	lStatus;
	int		nData;
	HKEY	hkKey;
	DWORD	dwType;
	DWORD cbData;
	DWORD dwStorage;
	DWORD	dwDisposition;

	//	Open an existing key or create a new key.
	lStatus = RegCreateKeyEx(
		HKEY_CURRENT_USER,
		szSubKeyName,
		0,
		szKeyClass,
		REG_OPTION_NON_VOLATILE,	//	Store values when exiting system
		KEY_READ,									//	Read the data
		NULL,
		&hkKey,										//	An handle to the openedkey
		&dwDisposition
	);
	if (ERROR_SUCCESS == lStatus || REG_CREATED_NEW_KEY != dwDisposition)
	  { 
    cbData = sizeof(DWORD);
		lStatus = RegQueryValueEx(hkKey,szSubKeys[rtType],NULL,&dwType,(UCHAR *)&dwStorage,&cbData);
		nData = (ERROR_SUCCESS == lStatus) ? dwStorage : nDefaultData;
	  }
	RegCloseKey(hkKey);
	return nData;
  }

//	Store data in the windows registry
void StoreData(enum ERegTypes rtType,int nData)
  {
	LONG	lStatus;
	HKEY	hkKey;
	DWORD	dwDisposition;
	DWORD	dwStorage;

	//	Open an existing key or create a new key.
	lStatus = RegCreateKeyEx(
		HKEY_CURRENT_USER,
		szSubKeyName,
		0,
		szKeyClass,
		REG_OPTION_NON_VOLATILE,	//	Store values when exiting system
		KEY_WRITE,								//	Everyone can tamper with the keys
		NULL,
		&hkKey,										//	An handle to the openedkey
		&dwDisposition
	);
	if (ERROR_SUCCESS == lStatus)
	  {
		dwStorage = nData;
		RegSetValueEx(hkKey,szSubKeys[rtType],0,REG_DWORD,(UCHAR *)&dwStorage,sizeof(DWORD));
	  }
	RegCloseKey(hkKey);
  }

