
SOCKET(2)                  UNIX Programmer's Manual                  SOCKET(2)

NNAAMMEE
     ssoocckkeett - create an endpoint for communication

SSYYNNOOPPSSIISS
     ##iinncclluuddee <<ssyyss//ttyyppeess..hh>>
     ##iinncclluuddee <<ssyyss//ssoocckkeett..hh>>

     _i_n_t
     ssoocckkeett(_i_n_t _d_o_m_a_i_n, _i_n_t _t_y_p_e, _i_n_t _p_r_o_t_o_c_o_l)

DDEESSCCRRIIPPTTIIOONN
     SSoocckkeett() creates an endpoint for communication and returns a descriptor.

     The _d_o_m_a_i_n parameter specifies a communications domain within which com-
     munication will take place; this selects the protocol family which should
     be used.  These families are defined in the include file <_s_y_s_/_s_o_c_k_e_t_._h>.
     The currently understood formats are

           AF_UNIX         (UNIX internal protocols),
           AF_INET         (ARPA Internet protocols),
           AF_ISO          (ISO protocols),
           AF_NS           (Xerox Network Systems protocols), and
           AF_IMPLINK      (IMP host at IMP link layer).

     The socket has the indicated _t_y_p_e, which specifies the semantics of com-
     munication.  Currently defined types are:

           SOCK_STREAM
           SOCK_DGRAM
           SOCK_RAW
           SOCK_SEQPACKET
           SOCK_RDM

     A SOCK_STREAM type provides sequenced, reliable, two-way connection based
     byte streams.  An out-of-band data transmission mechanism may be support-
     ed.  A SOCK_DGRAM socket supports datagrams (connectionless, unreliable
     messages of a fixed (typically small) maximum length).  A SOCK_SEQPACKET
     socket may provide a sequenced, reliable, two-way connection-based data
     transmission path for datagrams of fixed maximum length; a consumer may
     be required to read an entire packet with each read system call.  This
     facility is protocol specific, and presently implemented only for PF_NS.
     SOCK_RAW sockets provide access to internal network protocols and inter-
     faces.  The types SOCK_RAW, which is available only to the super-user,
     and SOCK_RDM, which is planned, but not yet implemented, are not de-
     scribed here.

     The _p_r_o_t_o_c_o_l specifies a particular protocol to be used with the socket.
     Normally only a single protocol exists to support a particular socket
     type within a given protocol family.  However, it is possible that many
     protocols may exist, in which case a particular protocol must be speci-
     fied in this manner.  The protocol number to use is particular to the
     communication domain in which communication is to take place; see
     protocols(5).

     Sockets of type SOCK_STREAM are full-duplex byte streams, similar to
     pipes.  A stream socket must be in a _c_o_n_n_e_c_t_e_d state before any data may
     be sent or received on it.  A connection to another socket is created
     with a connect(2) call.  Once connected, data may be transferred using
     read(2) and write(2) calls or some variant of the send(2) and recv(2)
     calls.  When a session has been completed a close(2) may be performed.
     Out-of-band data may also be transmitted as described in send(2) and re-
     ceived as described in recv(2).

     The communications protocols used to implement a SOCK_STREAM insure that
     data is not lost or duplicated.  If a piece of data for which the peer
     protocol has buffer space cannot be successfully transmitted within a
     reasonable length of time, then the connection is considered broken and
     calls will indicate an error with -1 returns and with ETIMEDOUT as the
     specific code in the global variable _e_r_r_n_o. The protocols optionally keep
     sockets ``warm'' by forcing transmissions roughly every minute in the ab-
     sence of other activity.  An error is then indicated if no response can
     be elicited on an otherwise idle connection for a extended period (e.g. 5
     minutes).  A SIGPIPE signal is raised if a process sends on a broken
     stream; this causes naive processes, which do not handle the signal, to
     exit.

     SOCK_SEQPACKET sockets employ the same system calls as SOCK_STREAM sock-
     ets.  The only difference is that read(2) calls will return only the
     amount of data requested, and any remaining in the arriving packet will
     be discarded.

     SOCK_DGRAM and SOCK_RAW sockets allow sending of datagrams to correspon-
     dents named in send(2) calls.  Datagrams are generally received with
     recvfrom(2),  which returns the next datagram with its return address.

     An fcntl(2) call can be used to specify a process group to receive a
     SIGURG signal when the out-of-band data arrives.  It may also enable non-
     blocking I/O and asynchronous notification of I/O events via SIGIO.

     The operation of sockets is controlled by socket level _o_p_t_i_o_n_s. These op-
     tions are defined in the file <_s_y_s_/_s_o_c_k_e_t_._h>. Setsockopt(2) and getsock-
     opt(2) are used to set and get options, respectively.

RREETTUURRNN VVAALLUUEESS
     A -1 is returned if an error occurs, otherwise the return value is a de-
     scriptor referencing the socket.

EERRRROORRSS
     The ssoocckkeett() call fails if:

     [EPROTONOSUPPORT]
                   The protocol type or the specified protocol is not support-
                   ed within this domain.

     [EMFILE]      The per-process descriptor table is full.

     [ENFILE]      The system file table is full.

     [EACCESS]     Permission to create a socket of the specified type and/or
                   protocol is denied.

     [ENOBUFS]     Insufficient buffer space is available.  The socket cannot
                   be created until sufficient resources are freed.

SSEEEE AALLSSOO
     accept(2),  bind(2),  connect(2),  getprotoent(3),  getsockname(2),
     getsockopt(2),  ioctl(2),  listen(2),  read(2),  recv(2),  select(2),
     send(2),  shutdown(2),  socketpair(2),  write(2)

     _A_n _I_n_t_r_o_d_u_c_t_o_r_y _4_._3 _B_S_D _I_n_t_e_r_p_r_o_c_e_s_s _C_o_m_m_u_n_i_c_a_t_i_o_n _T_u_t_o_r_i_a_l, reprinted in
     UNIX Programmer's Supplementary Documents Volume 1.

     _B_S_D _I_n_t_e_r_p_r_o_c_e_s_s _C_o_m_m_u_n_i_c_a_t_i_o_n _T_u_t_o_r_i_a_l, reprinted in UNIX Programmer's
     Supplementary Documents Volume 1.

HHIISSTTOORRYY
     The ssoocckkeett() function call appeared in 4.2BSD.

4.2 Berkeley Distribution       March 10, 1991                               2
