{$M 16384,0,131072} { sd kasamuistin koko jotta Exec-kutsu toimisi }
program SanoLuku;

uses Dos;

const
  MAXTOKENS = 100;		{ listan alkioiden enimmismr }
  NUMTOKENS = 24;		{ alkioiden lukumr }
  MAXLEN = 10;			{ luvun enimmispituus (-999999999) }
  INIFILENAME = 'SANOLUKU.INI';  { asetustiedoston nimi }

type
  Token =
  ( TYHJA, YKSI, KAKSI, KOLME, NELJA, VIISI, KUUSI, SEITSEMAN,
    KAHDEKSAN, YHDEKSAN, KYMMENEN, MONTA_KYMMENTA, TOISTA, SATA,
    MONTA_SATAA, TUHAT, MONTA_TUHATTA, MILJOONA, MONTA_MILJOONAA,
    NOLLA, MIINUS, PLUS, PILKKU, BLANKO );

const
  TokenString : array [0..NUMTOKENS-1] of string =
  ( '(tyhj)', 'yksi', 'kaksi', 'kolme', 'nelj', 'viisi', 'kuusi',
    'seitsemn', 'kahdeksan', 'yhdeksn', 'kymmenen', 'kymment',
    'toista', 'sata', 'sataa', 'tuhat', 'tuhatta', 'miljoona',
    'miljoonaa', 'nolla', 'miinus', 'plus', ',', ' ' );

  SoundString : array [0..NUMTOKENS-1] of string =
  ( '', '1', '2', '3', '4', '5', '6', '7',
    '8', '9', '10', '10x', '1x', '100',
    '100x', '1000', '1000x', '1000000', '1000000x',
    '0', 'miinus', '', 'pilkku', '' );

type
  TokenArray = array [1..MAXTOKENS] of Token;

  TokenList = object            { alkiolista }
    Tokens : TokenArray;
    TokenPtr : 0..MAXTOKENS;

    constructor Init;           { alustaa alkiolistan }
    function Count : Integer;   { palauttaa alkioiden lukumrn }
    procedure Add(T : Token);   { lis alkion listaan }
    procedure RemoveLast;       { poistaa viimeisen alkion listasta }
    procedure Print;            { tulostaa listan sislln }
    procedure Play;             { toistaa vastaavat nitiedostot }
  end;

var
  SoundFileExt : string;
  SoundPlayerName : string;


constructor TokenList.Init;
var i : 1..MAXTOKENS;
begin
  for i := 1 to MAXTOKENS do  { alusta lista tyhjill alkioilla }
    Tokens[i] := TYHJA;
  TokenPtr := 0;              { kelaa osoitin alkuun }
end; { TokenList.Init }

function TokenList.Count : Integer;
begin
  Count := TokenPtr;          { alkioiden lukumr = osoittimen lukema }
end; { TokenList.Count }

procedure TokenList.Add(T : Token);
begin
  Inc( TokenPtr );               { kasvata laskuria }
  if TokenPtr <= MAXTOKENS then  { tarkista ettei mene yli lopusta }
    Tokens[TokenPtr] := T;
end; { TokenList.Add }

procedure TokenList.RemoveLast;
begin
  Tokens[TokenPtr] := TYHJA;     { viimeiseksi alkioksi tyhj }
  Dec( TokenPtr );               { osoitinta pykl taaksepin }
end; { TokenList.RemoveLast }

procedure TokenList.Print;
var i : 0..MAXTOKENS;            { alkaa nollasta koska osoitin voi olla 0 }
begin
  for i := 1 to TokenPtr do
    Write( TokenString[Integer(Tokens[i])] );
end; { TokenList.Print }

procedure TokenList.Play;
var
  SoundFileName : string[13];
  i : 0..MAXTOKENS;
begin
  for i := 1 to TokenPtr do
  begin
    if SoundString[Integer(Tokens[i])] <> '' then
    begin
      SoundFileName := SoundString[Integer(Tokens[i])] + '.' + SoundFileExt;
      SwapVectors;
      Exec( SoundPlayerName, SoundFileName );
      SwapVectors;
    end
  end; { for i }
end; { TokenList.Play }

{ HandleHundreds: jsentele luku 'number' (vlill 0...999) }
{ alkioiksi ja lis alkiot listaan 'OutputList'. }
procedure HandleHundreds( var OutputList : TokenList;  number : Integer );
var factor, remainder, units : Integer;
begin
  factor := 100;   { kertoja: suurin yksikk alle tuhannen luvuissa }
  while factor > 0 do
  begin
    units := number div factor;     { montako kertojaa menee lukuun }

    case factor of                   { ksittele kertojan eri arvot }
      100: if units >= 1 then
           begin
             if units = 1 then           { yksikk }
               OutputList.Add( SATA )
             else
             begin                       { monikko }
               OutputList.Add( Token(units) );
               OutputList.Add( MONTA_SATAA );
             end;
           end;

      10:  if units >= 1 then
           begin
             if units = 1 then    { 'kymmenen' tai 'xxxtoista' }
             begin
               remainder := number mod factor;  { montako 'toista' }
               if remainder <> 0 then
               begin
                 OutputList.Add( Token(remainder) );
                 OutputList.Add( TOISTA );
                 number := number - units * factor; { tulostettu osa pois }
                 factor := factor div 10;           { seuraava kertoja }
               end
               else           { ei yhtn 'toista'; tasan kymmenen }
                 OutputList.Add( KYMMENEN );
             end
             else
             begin                       { monikko }
               OutputList.Add( Token(units) );
               OutputList.Add( MONTA_KYMMENTA );
             end;
           end;

      1:   if units > 0 then             { ykkset }
             OutputList.Add( Token(units) );
    end; { case }

    number := number - units * factor;   { vhenn luvusta tulostettu osa }
    factor := factor div 10;             { laske seuraava kertoja }
  end; { while factor > 0 }
end; { HandleHundreds }


procedure Say( S : string;  var Ok : Boolean );
var                          { ^ terveisi H. rnille ;-) }
  OutputList : TokenList;  { tekstialkiolista }
  i : Integer;
  ValCode : Integer;
  Trio : string[3];        { yhdeksnnumeroisen luvun yksi kolmikko }
  TrioValue : Integer;     { kolmikon arvo }
begin
  Ok := true;
  OutputList.Init;

  if Length(S) > MAXLEN then  { tarkista ettei ole liian pitk }
    Ok := false;

  for i := 1 to Length(S) do  { tarkista ettei ole vri merkkej }
    if not (S[i] in ['0'..'9', '+', '-']) then
      Ok := false;

  if S[1] = '-' then          { negatiivinen luku; miinus ja sanavli }
  begin
    OutputList.Add( MIINUS );
    OutputList.Add( BLANKO );
    Delete( S, 1, 1 );
  end
  else if S[1] = '+' then     { plusmerkki poistetaan tarpeettomana }
    Delete( S, 1, 1 );        { se on mukana alkioissa kaiken varalta }

  for i := Length(S)+1 to MAXLEN-1 do  { tyt vasemmalta maksimipituuteen }
    Insert( '0', S, 1 );               { nollilla }

  if Ok then
  begin
    for i := 0 to 2 do                   { kolme lukukolmikkoa (0,1,2) }
    begin
      Trio := Copy( S, i * 3 + 1, 3 );   { kopioi kolmikko Trio-merkkijonoon }
      Val( Trio, TrioValue, ValCode );   { muunna numeroksi }
      if ValCode <> 0 then
        Ok := false
      else
      begin
        if TrioValue <> 0 then
        begin
          HandleHundreds( OutputList, TrioValue );  { muunna arvo tekstiksi }

          if i = 0 then                 { ensimminen kolmikko: miljoonat }
          begin
            if TrioValue = 1 then       { yksikk }
            begin
              OutputList.RemoveLast;
              OutputList.Add( MILJOONA );
            end
            else
            begin                       { monikko }
              OutputList.Add( BLANKO );
              OutputList.Add( MONTA_MILJOONAA );
            end;
            OutputList.Add( BLANKO );
          end
          else if i = 1 then
          begin
            if TrioValue = 1 then
            begin
              OutputList.RemoveLast;
              OutputList.Add( TUHAT );
            end
            else
              OutputList.Add( MONTA_TUHATTA );
              OutputList.Add( BLANKO );
          end;
        end;
      end;
    end; { for i }
  end; { if Ok }

  if S = '000000000' then    { pelkki nollia koko luku }
  begin
    OutputList.Init;
    OutputList.Add( NOLLA );
  end;

  if Ok then        { mikli kaikki meni hyvin, tulosta teksti }
  begin
    OutputList.Print;
    OutputList.Play;
  end;
end; { Say }


{ FileExists: palauttaa True jos nimetty tiedosto on
  olemassa, muutoin False. }
function FileExists(Filename: string): Boolean;
var F : file;
begin
{$I-}                   { ota I/O-tarkistus pois plt }
  Assign(F, Filename);  { yhdist nimi tiedostoon }
  FileMode := 0;        { tiedoston ksittelytapa: 0 = vain luku }
  Reset(F);             { yrit kytt tiedostoa }
  Close(F);             { sulje saman tien }
{$I+}                   { I/O-tarkistus takaisin plle }
  { Tiedosto on olemassa mikli IOResult ei osoita I/O-virhett
    ja tiedoston nimi ei ole tyhj }
  FileExists := (IOResult = 0) and (Filename <> '');
end; { FileExists }


var
  i : Integer;
  NumberString : string;
  Ok, Done : Boolean;
  IniFile : Text;
  IniLine : string;

begin
  if FileExists(IniFileName) then
  begin
    Assign( IniFile, IniFileName );
    Reset( IniFile );
    while not Eof( IniFile ) do
    begin
      ReadLn( IniFile, IniLine );
      for i := 1 to Length(IniLine) do
        IniLine[i] := UpCase( IniLine[i] );
      if Pos( 'SOUNDPLAYERNAME', IniLine ) > 0 then
        SoundPlayerName := Copy( IniLine, Pos('=', IniLine)+1, Length(IniLine) );
      if Pos( 'SOUNDFILEEXT', IniLine ) > 0 then
        SoundFileExt := Copy( IniLine, Pos('=', IniLine)+1, Length(IniLine) );
    end; { while }
    Close( IniFile );
  end
  else
  begin
    WriteLn( 'SANOLUKU.INI puuttuu! Ei voi jatkaa.' );
    Halt;
  end;

  for i := 1 to ParamCount do   { sano kaikki komentorivilt annetut luvut }
  begin
    Say( ParamStr(i), Ok );
    WriteLn;
    if not Ok then
      WriteLn( 'Virhe luvussa!' );
  end; { for i }
              { kun komentorivilt annetut luvut loppuvat, aletaan kysell }
  Done := false;
  repeat
    Write('? ');
    ReadLn( NumberString );
    if NumberString = '' then
      Done := true
    else
    begin
      Say( NumberString, Ok );
      WriteLn;
      if not Ok then
        WriteLn( 'Virhe luvussa!' );
    end;
  until Done;
end.
