package jere.applets.onthisday;

/**
 * Filters events by date or other value.
 *
 * @author Jere Kpyaho
 * @version $Revision$
 */
public abstract class EventFilter  {
    protected Object filterValue;  // protected so that subclasses can use it

    /**
     * Accepts or rejects an event.
     *
     * @param event The event to accept or reject
     * @return True if the event is accepted, false otherwise
     */
    public abstract boolean accepts(Event event);

    /**
     * Sets the filter value for this filter.
     *
     * @param value The new filter value
     */
    public abstract void setFilterValue(Object value);

    /**
     * Gets the filter value of this filter.
     *
     * @return The filter value of this filter
     */
    public abstract Object getFilterValue();
} // EventFilter
