package jere.applets.onthisday;

import java.util.Date;
import java.util.Calendar;


/**
 * Filters events by date.
 *
 * @author Jere Kpyaho
 * @version $Revision$
 */
public class DateFilter extends EventFilter {
    /**
     * Constructs a date filter.
     *
     * @param filterDate The date to filter the events by
     */
    public DateFilter(Date filterDate) {
        filterValue = filterDate;
    }

    /**
     * Sets the filter date for this filter.
     *
     * @param filterDate The new filter date
     */
    public void setFilterValue(Object filterDate) {
        filterValue = filterDate;
    }

    /**
     * Gets the filter date of this filter.
     *
     * @return The filter date of this filter
     */
    public Object getFilterValue() {
        return filterValue;
    }

    /**
     * Accepts or rejects an event.
     *
     * @param event The event to accept or reject
     * @return True if the event is accepted, false otherwise
     */
    public boolean accepts(Event event) {
        // Make a calendar instance and set its time
        // from the filter value (cast as Date)
        Calendar fcal = Calendar.getInstance();
        fcal.setTime((Date) filterValue);

        // Do the same for the event's date stamp
        Calendar ecal = Calendar.getInstance();
        ecal.setTime(event.getDate());

        int eventDay = ecal.get(Calendar.DATE);
        int eventMonth = ecal.get(Calendar.MONTH);

        int filterDay = fcal.get(Calendar.DATE);
        int filterMonth = fcal.get(Calendar.MONTH);

        if ((eventMonth == filterMonth) && (eventDay == filterDay)) {
            return true;
        }
        return false;
    }
}

