/*
 * Decompiled with CFR 0.152.
 */
package jere.applets.onthisday;

import com.microstar.xml.SAXDriver;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Label;
import java.awt.List;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import jere.applets.AppletParameter;
import jere.applets.onthisday.ErrorHandler;
import jere.applets.onthisday.EventCanvas;
import jere.applets.onthisday.EventFinder;
import jere.applets.onthisday.EventSorter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class OnThisDay
extends Applet
implements ItemListener {
    public static final boolean DEBUG = true;
    EventFinder eventFinder;
    Label dateLabel;
    List topicList;
    Date filterDate;
    Hashtable events;
    Vector topics;
    EventCanvas eventCanvas;
    private String[][] info = new String[][]{{"datafile", "string", "Name of data file"}, {"date", "string MM-DD", "Event filter date (for testing)"}};

    public void init() {
        System.out.println(this.getAppletInfo());
        String dateString = this.getParameter("date");
        if (dateString == null) {
            this.filterDate = new Date();
        } else {
            int month = Integer.parseInt(dateString.substring(0, 2));
            int day = Integer.parseInt(dateString.substring(3, 5));
            this.filterDate = new Date();
            this.filterDate.setMonth(month - 1);
            this.filterDate.setDate(day);
            System.out.println(String.valueOf(String.valueOf(String.valueOf("month = ").concat(String.valueOf(month))).concat(String.valueOf(", day = "))).concat(String.valueOf(day)));
        }
        this.setLayout(new BorderLayout());
        Color topicForegroundColor = AppletParameter.getColor(this, "topicfgcolor", Color.black);
        Color topicBackgroundColor = AppletParameter.getColor(this, "topicbgcolor", new Color(255, 255, 153));
        this.topicList = new List(10);
        this.topicList.setForeground(topicForegroundColor);
        this.topicList.setBackground(topicBackgroundColor);
        this.topicList.setFont(new Font("SansSerif", 0, 12));
        this.topicList.addItemListener(this);
        DateFormat df = DateFormat.getDateInstance(0);
        StringBuffer buf = new StringBuffer(df.format(this.filterDate));
        if (Locale.getDefault().toString().startsWith("fi_FI")) {
            SimpleDateFormat sdf = new SimpleDateFormat("EEEE, ");
            buf.insert(0, sdf.format(this.filterDate));
        }
        char firstChar = buf.charAt(0);
        buf.setCharAt(0, Character.toUpperCase(firstChar));
        Color dateForegroundColor = AppletParameter.getColor(this, "datefgcolor", Color.black);
        Color dateBackgroundColor = AppletParameter.getColor(this, "datebgcolor", Color.orange);
        this.dateLabel = new Label(buf.toString());
        this.dateLabel.setFont(new Font("SansSerif", 1, 12));
        this.dateLabel.setBackground(dateBackgroundColor);
        this.dateLabel.setForeground(dateForegroundColor);
        this.eventCanvas = new EventCanvas();
        Color eventForegroundColor = AppletParameter.getColor(this, "eventfgcolor", Color.white);
        Color eventBackgroundColor = AppletParameter.getColor(this, "eventbgcolor", new Color(0, 204, 0));
        this.eventCanvas.setBackground(eventBackgroundColor);
        this.eventCanvas.setForeground(eventForegroundColor);
        this.add("North", this.dateLabel);
        this.add("Center", this.eventCanvas);
        this.add("West", this.topicList);
        this.showStatus("Loading events...");
        String dataFileName = this.getParameter("datafile");
        if (dataFileName != null) {
            BufferedReader reader;
            System.err.println(String.valueOf("datafile = ").concat(String.valueOf(dataFileName)));
            InputStream in = this.getClass().getResourceAsStream(String.valueOf("/").concat(String.valueOf(dataFileName)));
            if (in == null) {
                System.err.println("Input stream from resource file is null!");
            }
            if ((reader = new BufferedReader(new InputStreamReader(in))) == null) {
                System.err.println("Reader is null!");
            }
            this.eventFinder = new EventFinder(this.filterDate);
            try {
                SAXDriver parser = new SAXDriver();
                parser.setDocumentHandler(this.eventFinder);
                parser.setErrorHandler(new ErrorHandler());
                parser.parse(new InputSource(reader));
                this.events = this.eventFinder.getEvents();
                this.topics = this.eventFinder.getTopics();
            }
            catch (SAXParseException spe) {
                System.err.println(spe);
                spe.printStackTrace();
            }
            catch (SAXException sex) {
                System.err.println(sex);
                sex.printStackTrace();
            }
            catch (Exception ex) {
                System.err.println(ex);
                ex.printStackTrace();
            }
        } else {
            System.err.println("No data file specified!");
        }
        String topic = "";
        Hashtable topicNames = this.eventFinder.getTopicNames();
        if (this.topics != null) {
            Enumeration e = this.topics.elements();
            while (e.hasMoreElements()) {
                topic = (String)e.nextElement();
                String topicName = (String)topicNames.get(topic);
                if (topicName == null) continue;
                this.topicList.add(topicName);
            }
            if (this.topicList.getItemCount() > 1) {
                this.topicList.select(0);
                ItemEvent ie = new ItemEvent(this.topicList, 701, topic, 1);
                this.itemStateChanged(ie);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        int selected;
        List source = (List)e.getItemSelectable();
        if (source == this.topicList && (selected = this.topicList.getSelectedIndex()) >= 0) {
            String key = (String)this.topics.elementAt(selected);
            Vector eventList = (Vector)this.events.get(key);
            EventSorter.sort(eventList);
            this.eventCanvas.setEventList(eventList);
            this.eventCanvas.repaint();
        }
    }

    public String getAppletInfo() {
        return "On This Day v0.3\nCopyright \u00a9 2000 Jere K\u00e4pyaho";
    }

    public String[][] getParameterInfo() {
        return this.info;
    }
}

