unit About;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, RxVerInf;

resourcestring
  SVersion = 'Versio %s';

type
  TFrmAbout = class(TForm)
    Panel1: TPanel;
    ProgramIcon: TImage;
    ProductName: TLabel;
    Version: TLabel;
    Copyright: TLabel;
    OKButton: TButton;
    ImgDelphi: TImage;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    Ver: RxVerInf.TVersionInfo;
  public
    { Public declarations }
  end;

var
  FrmAbout: TFrmAbout;

implementation

{$R *.DFM}

procedure TFrmAbout.FormCreate(Sender: TObject);
begin
  Ver := TVersionInfo.Create(RxVerInf.AppFileName);
  if Ver.Valid then
  begin
    ProductName.Caption := Ver.ProductName + ' - ' + Ver.FileDescription;
    Version.Caption := Format(SVersion, [Ver.FileVersion]);
    Copyright.Caption := Ver.LegalCopyright;
    //Comments.Caption := Ver.Comments;
  end;
end;

procedure TFrmAbout.FormDestroy(Sender: TObject);
begin
  Ver.Free;
end;

end.

