import java.awt.*;

public class LEDCanvas extends Canvas {
    boolean isOn;
    Dimension minSize;
    int color;

    LEDCanvas(int newColor) {
        color = newColor;
        isOn = false;
        minSize = new Dimension(24, 24);
    }
    public void turnOn() {
        isOn = true;
        repaint();
    }
    public void turnOff() {
        isOn = false;
        repaint();
    }
    public void toggle() {
        if (isOn) turnOff();
        else      turnOn();
    }
    public void setColor(int newColor) {
        color = newColor;
        repaint();
    }
    public void paint(Graphics g) {
        Dimension sz = size();
        g.setColor(Color.black);
        g.fillOval(0, 0, sz.width-1, sz.height-1);
        g.setColor(isOn ? LEDColor.getOnColor(color) :
                          LEDColor.getOffColor(color));
        g.fillOval(1, 1, sz.width-4, sz.height-4);
    }
    public void update(Graphics g) {
        paint(g);
    }
    public Dimension preferredSize() {
        return minimumSize();
    }
    public synchronized Dimension minimumSize() {
        return minSize;
    }
}

