/* PUH.C -- puhelinmuistio-ohjelma */

#include <stdio.h>   /* printf(), gets(), fxxxx()... */
#include <io.h>      /* access() */
#include <stdlib.h>  /* exit(), EXIT_FAILURE */
#include <string.h>  /* strxxxx() */
#include <mem.h>     /* memxxxx() */

#define MAX_LKM 100   /* tietueiden enimmismr */

int valitse( void );              /* valikko */
void uusi_nimi( void );           /* lis uusi nimi */
void lue_rivi( char *, char * );  /* lue tieto kyttjlt */
int etsi_nimi( void );            /* etsi nimi listasta */
void poista_nimi( void );         /* poista nimi */
void nayta_nimet( void );         /* nyt kaikki nimet */
int lue_tiedot( void );           /* lue lista levylt */
int tallenna_tiedot( void );      /* kirjoita lista levylle */
int on_olemassa( const char * );  /* tarkista tiedoston olemassaolo */

typedef struct tagPUHELINTIETUE   /* tallennettavat tiedot */
{
    char sukunimi[30];
    char etunimi[20];
    char puhnro[30];
}
PUHELINTIETUE;

PUHELINTIETUE PuhLista[MAX_LKM];  /* kiinten kokoinen taulukko */
int lkm = 0;                      /* montako tietuetta taulukossa */
const char tiedostonimi[] = "PUH.DAT";  /* tallennustiedoston nimi */

int main( void )
{
    int valinta;

    if ( on_olemassa( tiedostonimi ) )
    {
        if ( lue_tiedot() != 0 )
        {
            fprintf( stderr, "Tietojen lukeminen ei onnistu!\n" );
            return -1;
        }
    }
    else
    {
        printf( "Tiedostoa %s ei ole olemassa.\n", tiedostonimi );
        printf( "Sellainen tehdn ohjelman pttyess.\n" );
    }

    do
    {
        valinta = valitse();
        switch ( valinta )
        {
            case 1:
                uusi_nimi();
                break;
            case 2:
                etsi_nimi();
                break;
            case 3:
                poista_nimi();
                break;
            case 4:
                nayta_nimet();
                break;
            default:
                break;
        }
    }
    while ( valinta != 5 );

    if ( tallenna_tiedot() != 0 )
    {
        fprintf( stderr, "Tietojen tallentaminen ei onnistu!\n" );
        return -1;
    }
    return 0;
}

int valitse( void )
{
    char rivi[50];
    int valinta;

    printf( "\n\n" );
    printf( "1. Lis uusi nimi\n" );
    printf( "2. Etsi nimi\n" );
    printf( "3. Poista nimi\n" );
    printf( "4. Nyt kaikki nimet\n" );
    printf( "5. Lopetus\n" );

    do
    {
        printf( "\nValitse numero: " );
        gets( rivi );
        if ( rivi[0] == '\0' )
           continue;
        valinta = atoi( rivi );
    }
    while ( valinta < 1 || valinta > 5 );

    return valinta;
}

void uusi_nimi( void )
{
    char rivi[30];

    if ( lkm == MAX_LKM )
    {
        printf( "\nLista on tynn!\n" );
        return;
    }

    memset( &PuhLista[lkm], sizeof(PUHELINTIETUE), '\0' );
    lue_rivi( "Sukunimi.....: ", rivi );
    strcpy( PuhLista[lkm].sukunimi, rivi );
    lue_rivi( "Etunimi......: ", rivi );
    strcpy( PuhLista[lkm].etunimi, rivi );
    lue_rivi( "Puhelinnumero: ", rivi );
    strcpy( PuhLista[lkm].puhnro, rivi );
    lkm++;
}

void lue_rivi( char *kehote, char *rivi )
{
    *rivi = '\0';
    do
    {
        printf( "%s", kehote );
        gets( rivi );
    }
    while ( *rivi == '\0' );
}

int etsi_nimi( void )
{
    char rivi[30];
    int i;

    printf( "Anna sukunimi: " );
    gets( rivi );
    if ( rivi[0] == '\0' )
       return -1;

    for ( i = 0;  i < lkm;  i++ )
    {
        if ( memicmp( &PuhLista[i], rivi, strlen(rivi) ) == 0 )
        {
            printf( "\n%s %s   %s\n", PuhLista[i].sukunimi,
                    PuhLista[i].etunimi, PuhLista[i].puhnro );
            return i;
        }
    }
    return -1;
}

void poista_nimi( void )
{
    int nro;

    nro = etsi_nimi();
    if ( nro == -1 )
        printf( "\nEi lydy!\n" );
    else
    {
        int i;

        for ( i = nro + 1;  i < lkm;  i++ )
            memcpy( &PuhLista[i-1], &PuhLista[i], sizeof(PUHELINTIETUE) );
        lkm--;
    }
}

void nayta_nimet( void )
{
    int i;

    printf( "\n" );
    for ( i = 0;  i < lkm;  i++ )
        printf( "%s %s   %s\n", PuhLista[i].sukunimi,
                PuhLista[i].etunimi, PuhLista[i].puhnro );
}

int lue_tiedot( void )
{
    FILE *fp;
    int i;
    char rivi[30];
    PUHELINTIETUE pt;

    fp = fopen( tiedostonimi, "rt" );
    if ( !fp )
       return -1;

    i = 0;
    while ( !feof( fp ) )
    {
        fgets( pt.sukunimi, sizeof(rivi), fp );
        fgets( pt.etunimi, sizeof(rivi), fp );
        fgets( pt.puhnro, sizeof(rivi), fp );
        pt.sukunimi[ strlen(pt.sukunimi)-1 ] = '\0';
        pt.etunimi[ strlen(pt.etunimi)-1 ] = '\0';
        pt.puhnro[ strlen(pt.puhnro)-1 ] = '\0';
        memcpy( &PuhLista[i], &pt, sizeof(PUHELINTIETUE) );
        i++;
        if ( i == MAX_LKM )
        {
            printf( "\nLista on tynn!\n" );
            break;
        }
    }
    lkm = i - 1;
    fclose( fp );
    return 0;
}

int tallenna_tiedot( void )
{
    FILE *fp;
    int i;

    fp = fopen( tiedostonimi, "wt" );
    if ( !fp )
       return -1;

    for ( i = 0;  i < lkm;  i++ )
    {
        fputs( PuhLista[i].sukunimi, fp );
        fputc( '\n', fp );
        fputs( PuhLista[i].etunimi, fp );
        fputc( '\n', fp );
        fputs( PuhLista[i].puhnro, fp );
        fputc( '\n', fp );
    }

    fclose( fp );
    return 0;
}

int on_olemassa( const char *tiedostonimi )
{
    return ( access( tiedostonimi, 0 ) == 0 );
}
